<?php

/*********************************************************************

 メインプログラム

*********************************************************************/

/********* ライセンス ************************************************

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 @Link http://www.php-labo.net/
 @Copyright(C) 2007-2012 PHP Labo
 @Author Knight <info at php-labo dot net>

*********************************************************************/

/********* 外部ファイル読み込み *************************************/

require_once './config.php';

set_include_path(get_include_path() . PATH_SEPARATOR . getcwd() . '/PEAR/');
require_once 'HTTP/OAuth/Consumer.php';

/********* メイン処理 ***********************************************/

//セッション開始
session();

//データ正規化
normalize();

//OAuth
$consumer = new HTTP_OAuth_Consumer(CONSUMER_KEY, CONSUMER_SECRET);

//モードに応じた処理を実行
if (!isset($_REQUEST['mode'])) {
	$_REQUEST['mode'] = null;
}
if ($_REQUEST['mode'] == 'auth') {
	auth();
} elseif ($_REQUEST['mode'] == 'retweet') {
	retweet();
} else {
	start();
}

exit;

/********* 関数の定義 ***********************************************/

/* 初期画面 */
function start()
{
	global $consumer;

	echo "<!DOCTYPE html>\n";
	echo "<html lang=\"ja\">\n";
	echo "<head>\n";
	echo "<meta charset=\"utf-8\" />\n";
	echo "<title>Twitter API</title>\n";
	echo "<link rel=\"stylesheet\" href=\"" . CSS_FILE . "\" />\n";
	echo "</head>\n";
	echo "<body>\n";
	echo "<header>\n";
	echo "<h1>Twitter API</h1>\n";
	echo "</header>\n";
	echo "<section>\n";
	echo "<p>Twitterで認証してリツイートを表示。</p>\n";
	echo "<ul>\n";
	echo "<li><a href=\"" . HTTP_URL . MAIN_FILE . "?mode=auth\">認証</a></li>\n";
	echo "</ul>\n";
	echo "</section>\n";
	echo "</body>\n";
	echo "</html>\n";

	return;
}

/* 認証 */
function auth()
{
	global $consumer;

	if (isset($_GET['denied'])) {
		header('Location: ' . HTTP_URL . MAIN_FILE);
	} elseif (isset($_GET['oauth_verifier'])) {
		try {
			$consumer->setToken($_SESSION['request_token']);
			$consumer->setTokenSecret($_SESSION['request_token_secret']);
			$consumer->getAccessToken('http://api.twitter.com/oauth/access_token', $_GET['oauth_verifier']);

			$_SESSION['token']        = $consumer->getToken();
			$_SESSION['token_secret'] = $consumer->getTokenSecret();
		} catch (Exception $e) {
			error($e->getMessage());
		}

		header('Location: ' . HTTP_URL . MAIN_FILE . '?mode=retweet');
	} else {
		try {
			$consumer->getRequestToken('http://api.twitter.com/oauth/request_token', HTTP_URL . MAIN_FILE . '?mode=auth');

			$_SESSION['request_token']        = $consumer->getToken();
			$_SESSION['request_token_secret'] = $consumer->getTokenSecret();
		} catch (Exception $e) {
			error($e->getMessage());
		}

		header('Location: ' . $consumer->getAuthorizeUrl('http://api.twitter.com/oauth/authenticate'));
	}

	return;
}

/* リツイート表示 */
function retweet()
{
	global $consumer;

	//入力内容をチェック
	if (empty($_GET['page'])) {
		$_GET['page'] = 1;
	}

	//トークンで認証
	$consumer->setToken($_SESSION['token']);
	$consumer->setTokenSecret($_SESSION['token_secret']);

	//ユーザー情報を取得
	$response = $consumer->sendRequest('http://api.twitter.com/1/statuses/retweeted_by_me.xml', array('page' => $_GET['page']), 'GET');

	$xml = simplexml_load_string($response->getBody());

	if ($xml->error) {
		error($xml->error);
	}

/*
header('Content-Type: text/html; charset=UTF-8');
print('<pre>');
print_r($xml);
print('<pre>');
exit;
*/

	//結果を出力
	echo "<!DOCTYPE html>\n";
	echo "<html lang=\"ja\">\n";
	echo "<head>\n";
	echo "<meta charset=\"utf-8\" />\n";
	echo "<title>Twitter API</title>\n";
	echo "<link rel=\"stylesheet\" href=\"" . CSS_FILE . "\" />\n";
	echo "</head>\n";
	echo "<body>\n";
	echo "<header>\n";
	echo "<h1>Twitter API</h1>\n";
	echo "</header>\n";
	echo "<section>\n";
	echo "<p>リツイートは以下のとおりです。</p>\n";
/*
echo "色々調整中。";
echo "<textarea cols=50 rows=50>";
foreach ($xml->status as $status) {
	if ($status->retweeted_status) {
		$user = (string)$status->retweeted_status->user->screen_name;
		$text = (string)$status->retweeted_status->text;
	} else {
		$user = null;
		$text = (string)$status->text;
	}

	echo htmlspecialchars((string)$status->id) . "\t";
	echo date('Y-m-d H:i:s', strtotime((string)$status->created_at)) . "\t";
	if ($user) {
		echo htmlspecialchars($user) . "\t";
	}
	echo htmlspecialchars($text) . "\n";
}
echo "</textarea>";
*/
	echo "<dl>\n";

	foreach ($xml->status as $status) {
		if ($status->retweeted_status) {
			$user = (string)$status->retweeted_status->user->screen_name;
			$text = (string)$status->retweeted_status->text;
		} else {
			$user = null;
			$text = (string)$status->text;
		}

		echo "<dt>" . date('Y/m/d H:i', strtotime((string)$status->created_at)) . "</dt>\n";
		echo "<dd>\n";
		if ($user) {
			echo '<em>RT @' . htmlspecialchars($user) . '</em> : ';
		}
		echo htmlspecialchars($text);
		echo "</dd>\n";
	}

	echo "<ul>\n";

	if ($_GET['page'] <= 1) {
		echo "<li>前のページ</li>\n";
	} else {
		echo "<li><a href=\"" . HTTP_URL . MAIN_FILE . "?mode=retweet&amp;page=" . ($_GET['page'] - 1) . "\">前のページ</a></li>\n";
	}
	echo "<li><a href=\"" . HTTP_URL . MAIN_FILE . "?mode=retweet&amp;page=" . ($_GET['page'] + 1) . "\">次のページ</a></li>\n";

	echo "</ul>\n";
	echo "<dl>\n";
	echo "<li><a href=\"" . HTTP_URL . MAIN_FILE . "\">戻る</a></li>\n";
	echo "</ul>\n";
	echo "</section>\n";
	echo "</body>\n";
	echo "</html>\n";

	return;
}

//エラー表示
function error($message)
{
	echo "<!DOCTYPE html>\n";
	echo "<html lang=\"ja\">\n";
	echo "<head>\n";
	echo "<meta charset=\"utf-8\" />\n";
	echo "<title>Twitter API</title>\n";
	echo "<link rel=\"stylesheet\" href=\"" . CSS_FILE . "\" />\n";
	echo "</head>\n";
	echo "<body>\n";
	echo "<header>\n";
	echo "<h1>Twitter API</h1>\n";
	echo "</header>\n";
	echo "<section>\n";
	echo "<p>エラーが発生しました。しばらくたってからもう一度お試しください。</p>\n";
	echo "<ul>\n";
	echo "<li>" . $message . "</li>\n";
	echo "</ul>\n";
	echo "<ul>\n";
	echo "<li><a href=\"javascript:history.back()\">前のページへ戻る</a></li>\n";
	echo "</ul>\n";
	echo "</section>\n";
	echo "</body>\n";
	echo "</html>\n";

	exit;
}

/* セッション開始 */
function session()
{
	$info = parse_url(HTTP_URL);

	session_set_cookie_params(SESSION_LIFETIME, $info['path']);
	session_cache_limiter(SESSION_CACHE);
	session_start();

	return;
}

/* 受信データ正規化 */
function normalize()
{
	//不正データ削除
	$_GET     = sanitize($_GET);
	$_POST    = sanitize($_POST);
	$_REQUEST = sanitize($_REQUEST);
	$_SERVER  = sanitize($_SERVER);
	$_COOKIE  = sanitize($_COOKIE);

	//改行コード統一
	$_GET     = unify($_GET);
	$_POST    = unify($_POST);
	$_REQUEST = unify($_REQUEST);
	$_SERVER  = unify($_SERVER);
	$_COOKIE  = unify($_COOKIE);

	return;
}

/* 不正データ削除 */
function sanitize($data)
{
	if (is_array($data)) {
		return array_map('sanitize', $data);
	}

	return str_replace("\0", '', $data);
}

/* 改行コード統一 */
function unify($data)
{
	if (is_array($data)) {
		return array_map('unify', $data);
	}

	$data = preg_replace("/\r?\n/", "\r", $data);
	$data = preg_replace("/\r/", "\n", $data);

	return $data;
}

?>
