<?php

/*********************************************************************

 メインプログラム

*********************************************************************/

/********* ライセンス ************************************************

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 @Link http://www.php-labo.net/
 @Copyright(C) 2007-2012 PHP Labo
 @Author Knight <info at php-labo dot net>

*********************************************************************/

/********* 外部ファイル読み込み *************************************/

require_once './config.php';

set_include_path(get_include_path() . PATH_SEPARATOR . getcwd() . '/PEAR/');
require_once 'HTTP/OAuth/Consumer.php';

/********* メイン処理 ***********************************************/

//セッション開始
session();

//データ正規化
normalize();

//OAuth
$consumer = new HTTP_OAuth_Consumer(CONSUMER_KEY, CONSUMER_SECRET);

//モードに応じた処理を実行
if (!isset($_REQUEST['mode'])) {
	$_REQUEST['mode'] = null;
}
if ($_REQUEST['mode'] == 'auth') {
	auth();
} elseif ($_REQUEST['mode'] == 'profile') {
	profile();
} else {
	start();
}

exit;

/********* 関数の定義 ***********************************************/

/* 初期画面 */
function start()
{
	global $consumer;

	echo "<!DOCTYPE html>\n";
	echo "<html lang=\"ja\">\n";
	echo "<head>\n";
	echo "<meta charset=\"utf-8\" />\n";
	echo "<title>Twitter API</title>\n";
	echo "<link rel=\"stylesheet\" href=\"" . CSS_FILE . "\" />\n";
	echo "<script>\n";
	echo "function openWindow() {\n";
	echo "window.open('" . HTTP_URL . MAIN_FILE . "?mode=auth', 'auth', 'width=800,height=600,scrollbars=yes');\n";
	echo "}\n";
	echo "function execFlash() {\n";
	echo "var flash = document.getElementById('flash') || document.getElementById('flash_ie');\n";
	echo "flash.playMovie();\n";
	echo "}\n";
	echo "</script>\n";
	echo "</head>\n";
	echo "<body>\n";
	echo "<header>\n";
	echo "<h1>Twitter API</h1>\n";
	echo "</header>\n";
	echo "<section>\n";
	echo "<p>Twitterで認証してプロフィールを表示。（Flashと連携。）</p>\n";
	echo "<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" width=\"500\" height=\"400\" align=\"middle\" id=\"flash_ie\">\n";
	echo "<param name=\"movie\" value=\"twitter.swf\" />\n";
	echo "<param name=\"quality\" value=\"high\" />\n";
	echo "<param name=\"bgcolor\" value=\"#CCCCCC\" />\n";
	echo "<param name=\"play\" value=\"true\" />\n";
	echo "<param name=\"loop\" value=\"true\" />\n";
	echo "<param name=\"wmode\" value=\"window\" />\n";
	echo "<param name=\"scale\" value=\"showall\" />\n";
	echo "<param name=\"menu\" value=\"true\" />\n";
	echo "<param name=\"devicefont\" value=\"false\" />\n";
	echo "<param name=\"salign\" value=\"\" />\n";
	echo "<param name=\"allowScriptAccess\" value=\"sameDomain\" />\n";
	echo "<!--[if !IE]>-->\n";
	echo "<object type=\"application/x-shockwave-flash\" data=\"twitter.swf\" width=\"500\" height=\"400\" id=\"flash\">\n";
	echo "<param name=\"movie\" value=\"twitter.swf\" />\n";
	echo "<param name=\"quality\" value=\"high\" />\n";
	echo "<param name=\"bgcolor\" value=\"#CCCCCC\" />\n";
	echo "<param name=\"play\" value=\"true\" />\n";
	echo "<param name=\"loop\" value=\"true\" />\n";
	echo "<param name=\"wmode\" value=\"window\" />\n";
	echo "<param name=\"scale\" value=\"showall\" />\n";
	echo "<param name=\"menu\" value=\"true\" />\n";
	echo "<param name=\"devicefont\" value=\"false\" />\n";
	echo "<param name=\"salign\" value=\"\" />\n";
	echo "<param name=\"allowScriptAccess\" value=\"sameDomain\" />\n";
	echo "<!--<![endif]-->\n";
	echo "<a href=\"http://www.adobe.com/go/getflash\">\n";
	echo "<img src=\"http://www.adobe.com/images/shared/download_buttons/get_flash_player.gif\" alt=\"Adobe Flash Player を取得\" />\n";
	echo "</a>\n";
	echo "<!--[if !IE]>-->\n";
	echo "</object>\n";
	echo "<!--<![endif]-->\n";
	echo "</object>\n";
	echo "</section>\n";
	echo "</body>\n";
	echo "</html>\n";

	return;
}

/* 認証 */
function auth()
{
	global $consumer;

	if (isset($_GET['denied'])) {
		echo "<!DOCTYPE html>\n";
		echo "<html lang=\"ja\">\n";
		echo "<head>\n";
		echo "<meta charset=\"utf-8\" />\n";
		echo "<title>Twitter API</title>\n";
		echo "</head>\n";
		echo "<body>\n";
		echo "<p>認証がキャンセルされました。</p>\n";
		echo "</body>\n";
		echo "</html>\n";
	} elseif (isset($_GET['oauth_verifier'])) {
		try {
			$consumer->setToken($_SESSION['request_token']);
			$consumer->setTokenSecret($_SESSION['request_token_secret']);
			$consumer->getAccessToken('http://api.twitter.com/oauth/access_token', $_GET['oauth_verifier']);

			$_SESSION['token']        = $consumer->getToken();
			$_SESSION['token_secret'] = $consumer->getTokenSecret();
		} catch (Exception $e) {
			error($e->getMessage());
		}

		echo "<!DOCTYPE html>\n";
		echo "<html lang=\"ja\">\n";
		echo "<head>\n";
		echo "<meta charset=\"utf-8\" />\n";
		echo "<title>Twitter API</title>\n";
		echo "</head>\n";
		echo "<body>\n";
		echo "<script>\n";
		echo "window.opener.execFlash();\n";
		echo "window.close();\n";
		echo "</script>\n";
		echo "</body>\n";
		echo "</html>\n";
	} else {
		try {
			$consumer->getRequestToken('http://api.twitter.com/oauth/request_token', HTTP_URL . MAIN_FILE . '?mode=auth');

			$_SESSION['request_token']        = $consumer->getToken();
			$_SESSION['request_token_secret'] = $consumer->getTokenSecret();
		} catch (Exception $e) {
			error($e->getMessage());
		}

		echo "<!DOCTYPE html>\n";
		echo "<html lang=\"ja\">\n";
		echo "<head>\n";
		echo "<meta charset=\"utf-8\" />\n";
		echo "<title>Twitter API</title>\n";
		echo "</head>\n";
		echo "<body>\n";
		echo "<script>\n";
		echo "window.location.href='" . $consumer->getAuthorizeUrl('http://api.twitter.com/oauth/authenticate') . "';\n";
		echo "</script>\n";
		echo "</body>\n";
		echo "</html>\n";
	}

	return;
}

/* プロフィール表示 */
function profile()
{
	global $consumer;

	//トークンで認証
	$consumer->setToken($_SESSION['token']);
	$consumer->setTokenSecret($_SESSION['token_secret']);

	//ユーザー情報を取得
	$response = $consumer->sendRequest('http://api.twitter.com/1/account/verify_credentials.xml', array(), 'GET');

	$xml = simplexml_load_string($response->getBody());

	if ($xml->error) {
		error($xml->error);
	}

	//結果を出力
	header('Content-Type: text/xml; charset=utf-8');

	echo "<profile>\n";
	echo "<id>" . htmlspecialchars((string)$xml->id) . "</id>\n";
	echo "<name>" . htmlspecialchars((string)$xml->name) . "</name>\n";
	echo "<screen_name>" . htmlspecialchars((string)$xml->screen_name) . "</screen_name>\n";
	echo "<location>" . htmlspecialchars((string)$xml->location) . "</location>\n";
	echo "<description>" . htmlspecialchars((string)$xml->description) . "</description>\n";
	echo "<profile_image_url>" . htmlspecialchars((string)$xml->profile_image_url) . "</profile_image_url>\n";
	echo "<followers_count>" . htmlspecialchars((string)$xml->followers_count) . "</followers_count>\n";
	echo "<friends_count>" . htmlspecialchars((string)$xml->friends_count) . "</friends_count>\n";
	echo "</profile>\n";

	return;
}

//エラー表示
function error($message)
{
	echo "<!DOCTYPE html>\n";
	echo "<html lang=\"ja\">\n";
	echo "<head>\n";
	echo "<meta charset=\"utf-8\" />\n";
	echo "<title>Twitter API</title>\n";
	echo "<link rel=\"stylesheet\" href=\"" . CSS_FILE . "\" />\n";
	echo "</head>\n";
	echo "<body>\n";
	echo "<header>\n";
	echo "<h1>Twitter API</h1>\n";
	echo "</header>\n";
	echo "<section>\n";
	echo "<p>エラーが発生しました。しばらくたってからもう一度お試しください。</p>\n";
	echo "<ul>\n";
	echo "<li>" . $message . "</li>\n";
	echo "</ul>\n";
	echo "<ul>\n";
	echo "<li><a href=\"javascript:history.back()\">前のページへ戻る</a></li>\n";
	echo "</ul>\n";
	echo "</section>\n";
	echo "</body>\n";
	echo "</html>\n";

	exit;
}

/* セッション開始 */
function session()
{
	$info = parse_url(HTTP_URL);

	session_set_cookie_params(SESSION_LIFETIME, $info['path']);
	session_cache_limiter(SESSION_CACHE);
	session_start();

	return;
}

/* 受信データ正規化 */
function normalize()
{
	//不正データ削除
	$_GET     = sanitize($_GET);
	$_POST    = sanitize($_POST);
	$_REQUEST = sanitize($_REQUEST);
	$_SERVER  = sanitize($_SERVER);
	$_COOKIE  = sanitize($_COOKIE);

	//改行コード統一
	$_GET     = unify($_GET);
	$_POST    = unify($_POST);
	$_REQUEST = unify($_REQUEST);
	$_SERVER  = unify($_SERVER);
	$_COOKIE  = unify($_COOKIE);

	return;
}

/* 不正データ削除 */
function sanitize($data)
{
	if (is_array($data)) {
		return array_map('sanitize', $data);
	}

	return str_replace("\0", '', $data);
}

/* 改行コード統一 */
function unify($data)
{
	if (is_array($data)) {
		return array_map('unify', $data);
	}

	$data = preg_replace("/\r?\n/", "\r", $data);
	$data = preg_replace("/\r/", "\n", $data);

	return $data;
}

?>
