<?php

/*********************************************************************

 メインプログラム

*********************************************************************/

/********* ライセンス ************************************************

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 @Link http://www.php-labo.net/
 @Copyright(C) 2007-2012 PHP Labo
 @Author Knight <info at php-labo dot net>

*********************************************************************/

/********* 外部ファイル読み込み *************************************/

require_once './config.php';

set_include_path(get_include_path() . PATH_SEPARATOR . getcwd() . '/PEAR/');
require_once 'HTTP/OAuth/Consumer.php';

/********* メイン処理 ***********************************************/

//セッション開始
session();

//データ正規化
normalize();

//OAuth
$consumer = new HTTP_OAuth_Consumer(CONSUMER_KEY, CONSUMER_SECRET);

//認証情報
$twitter = twitter();

//モードに応じた処理を実行
if (!isset($_REQUEST['mode'])) {
	$_REQUEST['mode'] = null;
}
if (empty($twitter)) {
	if ($_REQUEST['mode'] == 'auth') {
		auth();
	} else {
		notice();
	}
} else {
	page();
}

exit;

/********* 関数の定義 ***********************************************/

/* 認証画面 */
function notice()
{
	global $consumer;

	$_SESSION['REQUEST_URI'] = $_SERVER['REQUEST_URI'];

	if (isset($_COOKIE['twitter'])) {
		header('Location: ' . HTTP_URL . MAIN_FILE . '?mode=auth');
	} else {
		echo "<!DOCTYPE html>\n";
		echo "<html lang=\"ja\">\n";
		echo "<head>\n";
		echo "<meta charset=\"utf-8\" />\n";
		echo "<title>Twitter API</title>\n";
		echo "<link rel=\"stylesheet\" href=\"" . CSS_FILE . "\" />\n";
		echo "</head>\n";
		echo "<body>\n";
		echo "<header>\n";
		echo "<h1>Twitter API</h1>\n";
		echo "</header>\n";
		echo "<section>\n";
		echo "<p>Twitterで認証してください。</p>\n";
		echo "<ul>\n";
		echo "<li><a href=\"" . HTTP_URL . MAIN_FILE . "?mode=auth\">認証</a></li>\n";
		echo "</ul>\n";
		echo "</section>\n";
		echo "</body>\n";
		echo "</html>\n";
	}

	return;
}

/* 認証 */
function auth()
{
	global $consumer;

	if (isset($_GET['denied'])) {
		//認証を拒否
		header('Location: ' . HTTP_URL . MAIN_FILE);
	} elseif (isset($_GET['oauth_verifier'])) {
		//認証データを取得
		try {
			$consumer->setToken($_SESSION['request_token']);
			$consumer->setTokenSecret($_SESSION['request_token_secret']);
			$consumer->getAccessToken('http://api.twitter.com/oauth/access_token', $_GET['oauth_verifier']);

			$_SESSION['token']        = $consumer->getToken();
			$_SESSION['token_secret'] = $consumer->getTokenSecret();
		} catch (Exception $e) {
			error($e->getMessage());
		}

		//認証フラグを記録
		setcookie('twitter', true, time() + COOKIE_EXPIRE);

		//ユーザー情報を取得
		$response = $consumer->sendRequest('http://api.twitter.com/1/account/verify_credentials.xml', array(), 'GET');

		$xml = simplexml_load_string($response->getBody());

		if ($xml->error) {
			error($xml->error);
		}

		$_SESSION['twitter'] = array(
			'id'          => (string)$xml->id,
			'screen_name' => (string)$xml->screen_name
		);

		header('Location: ' . $_SESSION['REQUEST_URI']);
	} else {
		//認証フラグを削除
		setcookie('twitter', null, 0);

		//認証を開始
		try {
			$consumer->getRequestToken('http://api.twitter.com/oauth/request_token', HTTP_URL . MAIN_FILE . '?mode=auth');

			$_SESSION['request_token']        = $consumer->getToken();
			$_SESSION['request_token_secret'] = $consumer->getTokenSecret();
		} catch (Exception $e) {
			error($e->getMessage());
		}

		header('Location: ' . $consumer->getAuthorizeUrl('http://api.twitter.com/oauth/authenticate'));
	}

	exit;
}

/* 専用ページ表示 */
function page()
{
	global $consumer, $twitter;

	//結果を出力
	echo "<!DOCTYPE html>\n";
	echo "<html lang=\"ja\">\n";
	echo "<head>\n";
	echo "<meta charset=\"utf-8\" />\n";
	echo "<title>Twitter API</title>\n";
	echo "<link rel=\"stylesheet\" href=\"" . CSS_FILE . "\" />\n";
	echo "</head>\n";
	echo "<body>\n";
	echo "<header>\n";
	echo "<h1>Twitter API</h1>\n";
	echo "</header>\n";
	echo "<section>\n";
	echo "<p>ここは @" . htmlspecialchars($twitter['screen_name']) . " さんの専用ページです。ログイン情報は以下のとおりです。</p>\n";
	echo "<table summary=\"Twitter\">\n";
	echo "<tr><th>id</th><td>" . htmlspecialchars($twitter['id']) . "</td></tr>\n";
	echo "<tr><th>screen_name</th><td>" . htmlspecialchars($twitter['screen_name']) . "</td></tr>\n";
	echo "</table>\n";
	echo "</section>\n";
	echo "</body>\n";
	echo "</html>\n";

	return;
}

//エラー表示
function error($message)
{
	echo "<!DOCTYPE html>\n";
	echo "<html lang=\"ja\">\n";
	echo "<head>\n";
	echo "<meta charset=\"utf-8\" />\n";
	echo "<title>Twitter API</title>\n";
	echo "<link rel=\"stylesheet\" href=\"" . CSS_FILE . "\" />\n";
	echo "</head>\n";
	echo "<body>\n";
	echo "<header>\n";
	echo "<h1>Twitter API</h1>\n";
	echo "</header>\n";
	echo "<section>\n";
	echo "<p>エラーが発生しました。しばらくたってからもう一度お試しください。</p>\n";
	echo "<ul>\n";
	echo "<li>" . $message . "</li>\n";
	echo "</ul>\n";
	echo "<ul>\n";
	echo "<li><a href=\"javascript:history.back()\">前のページへ戻る</a></li>\n";
	echo "</ul>\n";
	echo "</section>\n";
	echo "</body>\n";
	echo "</html>\n";

	exit;
}

/* セッション開始 */
function session()
{
	$info = parse_url(HTTP_URL);

	session_set_cookie_params(SESSION_LIFETIME, $info['path']);
	session_cache_limiter(SESSION_CACHE);
	session_start();

	return;
}

/* 受信データ正規化 */
function normalize()
{
	//不正データ削除
	$_GET     = sanitize($_GET);
	$_POST    = sanitize($_POST);
	$_REQUEST = sanitize($_REQUEST);
	$_SERVER  = sanitize($_SERVER);
	$_COOKIE  = sanitize($_COOKIE);

	//改行コード統一
	$_GET     = unify($_GET);
	$_POST    = unify($_POST);
	$_REQUEST = unify($_REQUEST);
	$_SERVER  = unify($_SERVER);
	$_COOKIE  = unify($_COOKIE);

	return;
}

/* 認証情報 */
function twitter()
{
	if (isset($_SESSION['twitter'])) {
		return $_SESSION['twitter'];
	} else {
		return array();
	}
}

/* 不正データ削除 */
function sanitize($data)
{
	if (is_array($data)) {
		return array_map('sanitize', $data);
	}

	return str_replace("\0", '', $data);
}

/* 改行コード統一 */
function unify($data)
{
	if (is_array($data)) {
		return array_map('unify', $data);
	}

	$data = preg_replace("/\r?\n/", "\r", $data);
	$data = preg_replace("/\r/", "\n", $data);

	return $data;
}

?>
