$(document).ready(function() {
	/*
	 * ファイルアップロード
	 */
	if ($('#upload').size() > 0) {
/*
		$(document).on('drop', function(e) {
			return false;
		}).on('dragover', function(e) {
			return false;
		});
*/

		$('#upload').upload({
			form: $('#upload form').get(0),
			url: $('#upload form').attr('action'),
			name: 'files[]',
			dragover: function() {
				$('#upload').addClass('dragover');
			},
			dragleave: function() {
				$('#upload').removeClass('dragover');
			},
			initialize: function() {
				$('#upload').removeClass('dragover');
				$('#upload > p').append('<br />アップロードを開始します。<div id="progress"></div>');
			},
			progress: function(total, loaded, percent) {
				$('#progress').html('アップロードしています。' + (total ? ' | ' + Math.round(total / 1024) + 'KB 中 ' + Math.round(loaded / 1024) + 'KB 読み込み | 進捗' + percent + '%' : ''));
			},
			success: function() {
				$('#upload > p').append('アップロードに成功しました。');

				var file = $('#upload form input[name="target"]').val();

				window.parent.$('img#' + file).attr('src', window.parent.$('img#' + file).attr('src') + '&' + new Date().getTime());
				window.parent.$('#' + file + '_menu').show();
				window.parent.$.fn.subwindow.close();
			},
			error: function(message) {
				$('#upload > p').append('アップロード失敗しました。 | ' + message);
			},
		});
	}
});
