$(document).ready(function() {
	/*
	 * プレビュー
	 */
	$('.preview').click(function() {
		$(this).closest('form').attr('target', '_blank');
		$(this).closest('form').find('input[name=preview]').val('yes');

		$(this).closest('form').submit();

		$(this).closest('form').find('input[name=preview]').val('no');
		$(this).closest('form').attr('target', '');

		return false;
	});
	$('.close').click(function() {
		window.close();

		return false;
	});

	/*
	 * バリデート
	 */
	$('form#class_post').submit(function() {
		var form = $(this);

		if (form.find('input[name=preview]').val() == 'no' && typeof flag === 'undefined') {
			$.ajax({
				type: form.attr('method'),
				url: form.attr('action'),
				cache: false,
				data: form.serialize() + '&type=json',
				dataType: 'json',
				success: function(response)
				{
					$('div.warning').remove();

					if (response.status == 'OK') {
						flag = true;

						form.submit();
					} else if (response.status == 'WARNING') {
						var messages = [];

						for (var key in response.messages) {
							if (form.find('[name=' + key + ']').size()) {
								form.find('[name=' + key + ']').parent().append('<div class="warning">' + response.messages[key] + '</a>');
							} else {
								messages.push(response.messages[key]);
							}
						}

						if (messages.length) {
							window.alert(messages.join('\n'));
						}
					} else if (response.status == 'ERROR') {
						window.alert(response.message);
					} else {
						window.alert('予期しないエラーが発生しました。');
					}
				},
				error: function(request, status, errorThrown) {
					console.log(request);
					console.log(status);
					console.log(errorThrown);

					window.alert('通信エラーが発生しました。');
				}
			});

			return false;
		} else {
			return true;
		}
	});
	$('form#member_post').submit(function() {
		var form = $(this);

		if (form.find('input[name=preview]').val() == 'no' && typeof flag === 'undefined') {
			$.ajax({
				type: form.attr('method'),
				url: form.attr('action'),
				cache: false,
				data: form.serialize() + '&type=json',
				dataType: 'json',
				success: function(response)
				{
					$('div.warning').remove();

					if (response.status == 'OK') {
						flag = true;

						form.submit();
					} else if (response.status == 'WARNING') {
						var messages = [];

						for (var key in response.messages) {
							if (form.find('[name=' + key + ']').size()) {
								form.find('[name=' + key + ']').parent().append('<div class="warning">' + response.messages[key] + '</a>');
							} else {
								messages.push(response.messages[key]);
							}
						}

						if (messages.length) {
							window.alert(messages.join('\n'));
						}
					} else if (response.status == 'ERROR') {
						window.alert(response.message);
					} else {
						window.alert('予期しないエラーが発生しました。');
					}
				},
				error: function(request, status, errorThrown) {
					console.log(request);
					console.log(status);
					console.log(errorThrown);

					window.alert('通信エラーが発生しました。');
				}
			});

			return false;
		} else {
			return true;
		}
	});

	/*
	 * アップロードファイルの処理
	 */
	$('a#image1_delete').click(function() {
		$.ajax({
			type: 'get',
			url: $(this).attr('href'),
			cache: false,
			data: 'type=json',
			dataType: 'json',
			success: function(response)
			{
				if (response.status == 'OK') {
					$('img#image1').attr('src', window.parent.$('img#image1').attr('src') + '?' + new Date().getTime());
					$('#image1_menu').hide();
				} else {
					window.alert('予期しないエラーが発生しました。');
				}
			},
			error: function(request, status, errorThrown) {
				console.log(request);
				console.log(status);
				console.log(errorThrown);

				window.alert('通信エラーが発生しました。');
			}
		});

		return false;
	});
	$('a#image2_delete').click(function() {
		$.ajax({
			type: 'get',
			url: $(this).attr('href'),
			cache: false,
			data: 'type=json',
			dataType: 'json',
			success: function(response)
			{
				if (response.status == 'OK') {
					$('img#image2').attr('src', window.parent.$('img#image2').attr('src') + '?' + new Date().getTime());
					$('#image2_menu').hide();
				} else {
					window.alert('予期しないエラーが発生しました。');
				}
			},
			error: function(request, status, errorThrown) {
				console.log(request);
				console.log(status);
				console.log(errorThrown);

				window.alert('通信エラーが発生しました。');
			}
		});

		return false;
	});
	if ($('form#class_post').size() > 0) {
		$.ajax({
			type: 'get',
			url: $('img#image1').attr('src'),
			cache: false,
			data: 'type=json',
			dataType: 'json',
			success: function(response)
			{
				if (response.status == 'OK') {
					if (response.mime == null) {
						$('#image1_menu').hide();
					}
				} else {
					window.alert('予期しないエラーが発生しました。');
				}
			},
			error: function(request, status, errorThrown) {
				console.log(request);
				console.log(status);
				console.log(errorThrown);

				window.alert('通信エラーが発生しました。');
			}
		});
		$.ajax({
			type: 'get',
			url: $('img#image2').attr('src'),
			cache: false,
			data: 'type=json',
			dataType: 'json',
			success: function(response)
			{
				if (response.status == 'OK') {
					if (response.mime == null) {
						$('#image2_menu').hide();
					}
				} else {
					window.alert('予期しないエラーが発生しました。');
				}
			},
			error: function(request, status, errorThrown) {
				console.log(request);
				console.log(status);
				console.log(errorThrown);

				window.alert('通信エラーが発生しました。');
			}
		});
	}

	/*
	 * 並び替え
	 */
	$('#sortable table tbody').sortable({
		handle: 'span.handle',
		update: function(event, ui) {
			var sort = [];
			$.each($('#sortable table tbody').sortable('toArray'), function(i) {
				this.match(/^sort_(\d+)$/);

				sort.push('sort[' + RegExp.$1 + ']=' + (i + 1));
			});

			$.ajax({
				type: $('#sortable').attr('method'),
				url: $('#sortable').attr('action'),
				cache: false,
				data: 'type=json&token=' + $('#sortable').find('input[name=token]').val() + '&' + sort.join('&'),
				dataType: 'json',
				success: function(response) {
					if (response.status != 'OK') {
						window.alert(response.message);
						window.location.reload();
					}
				},
				error: function(request, status, errorThrown) {
					console.log(request);
					console.log(status);
					console.log(errorThrown);

					window.alert('error');
					window.location.reload();
				}
			});
		}
	});

	/*
	 * 削除確認
	 */
	$('a.delete').click(function() {
		return confirm('本当に削除してもよろしいですか？');
	});
	$('form.delete').submit(function() {
		return confirm('本当に削除してもよろしいですか？');
	});

	/*
	 * 一括削除
	 */
	$('form input.bulk').change(function() {
		var data = {
			'type'  : 'json',
			'id'     : $(this).val(),
			'checked': $(this).prop('checked') ? 1 : 0,
			'token'  : $('form#member_delete input[name="token"]').val()
		};
		$.post($('form#member_delete').attr('action'), data, function(response) {
			if (response.status != 'OK') {
				window.alert('通信エラーが発生しました。');
			}
		}, 'json');

		return false;
	});
	$('form input.bulks').change(function() {
		if ($(this).prop('checked')) {
			$('form input.bulk').prop('checked', true);
		} else {
			$('form input.bulk').prop('checked', false);
		}

		var list = {};
		$('form input.bulk').each(function() {
			list[$(this).val()] = $(this).prop('checked') ? 1 : 0;
		});

		var data = {
			'type'  : 'json',
			'list'  : list,
			'token' : $('form#member_delete input[name="token"]').val()
		};
		$.post($('form#member_delete').attr('action'), data, function(response) {
			if (response.status != 'OK') {
				window.alert('通信エラーが発生しました。');
			}
		}, 'json');

		return false;
	});
	if ($('form input.bulk').size() > 0) {
		var flag = true;
		$('form input.bulk').each(function() {
			if ($(this).prop('checked') == false) {
				flag = false;
			}
		});
		if (flag == true) {
			$('form input.bulks').prop('checked', true);
		}
	}

	/*
	 * サブウインドウ
	 */
	$('a.class_image_upload').subwindow({
		width: 500,
		height: 400,
		close: '×',
		fade: 500
	});
	$('a.class_image_process').subwindow({
		width: 900,
		height: 600,
		close: '×',
		fade: 500
	});
});
