<?php import('app/views/header.php') ?>

		<h2>名簿一覧</h2>
		<table>
			<tr>
				<th>名前</th>
				<th>名前（フリガナ）</th>
				<th>成績</th>
				<th>誕生日</th>
				<th>メールアドレス</th>
			</tr>
			<?php foreach ($view['members'] as $member) : ?>
			<tr>
				<td><?php h($member['name']) ?></td>
				<td><?php h($member['name_kana']) ?></td>
				<td><?php h($member['grade']) ?></td>
				<td><?php h(localdate('Y年m月d日', $member['birthday'])) ?></td>
				<td><?php h($member['email']) ?></td>
			</tr>
			<?php endforeach ?>
		</table>

		<h3>ページ移動</h3>
		<ul>
			<li><?php if ($_GET['page'] > 1) : ?><a href="<?php t(MAIN_FILE) ?>/class/<?php t($params[1]) ?>?page=<?php t($_GET['page'] - 1) ?>">前のページ</a><?php else : ?>前のページ<?php endif ?></li>
			<li><?php if ($view['member_page'] > $_GET['page']) : ?><a href="<?php t(MAIN_FILE) ?>/class/<?php t($params[1]) ?>?page=<?php t($_GET['page'] + 1) ?>">次のページ</a><?php else : ?>次のページ<?php endif ?></li>
		</ul>
		<ul>
			<?php for ($i = 1; $i <= $view['member_page']; $i++) : ?>
			<li><?php if ($i != $_GET['page']) : ?><a href="<?php t(MAIN_FILE) ?>/class/<?php t($params[1]) ?>?page=<?php t($i) ?>"><?php t($i) ?></a><?php else : ?><?php t($i) ?><?php endif ?></li>
			<?php endfor ?>
		</ul>

<?php import('app/views/footer.php') ?>
