<?php import('app/views/admin/header.php') ?>

	<?php if (isset($_POST['preview']) and $_POST['preview'] == 'yes') : ?>
		<h2>確認</h2>
		<dl>
			<dt>教室</dt>
				<dd><?php h($view['class_id']) ?></dd>
			<dt>名前</dt>
				<dd><?php h($view['name']) ?></dd>
			<dt>名前（フリガナ）</dt>
				<dd><?php h($view['name_kana']) ?></dd>
			<dt>成績</dt>
				<dd><?php h($view['grade']) ?></dd>
			<dt>誕生日</dt>
				<dd><?php h($view['birthday']) ?></dd>
			<dt>メールアドレス</dt>
				<dd><?php h($view['email']) ?></dd>
			<dt>メモ</dt>
				<dd><?php h($view['memo']) ?></dd>
		</dl>
		<p><a href="#" class="close">閉じる</a></p>
	<?php else : ?>
		<h2><?php $view['id'] ? h('名簿編集') : h('名簿登録') ?></h2>

		<?php if (isset($view['warnings'])) : ?>
		<ul>
			<?php foreach ($view['warnings'] as $warning) : ?>
			<li><?php h($warning) ?></li>
			<?php endforeach ?>
		</ul>
		<?php endif ?>

		<form action="<?php t(MAIN_FILE) ?>/admin/member_form<?php $view['id'] ? t('?id=' . $view['id']) : '' ?>" method="post" id="member_post">
			<fieldset>
				<legend>登録フォーム</legend>
				<input type="hidden" name="token" value="<?php t($view['token']) ?>" />
				<input type="hidden" name="id" value="<?php t($view['id']) ?>" />
				<input type="hidden" name="preview" value="no" />
				<dl>
					<dt>教室</dt>
						<dd>
							<select name="class_id">
								<option value=""></option>
								<?php foreach ($view['classes'] as $class) : ?>
								<option value="<?php h($class['id']) ?>"<?php h($class['id'] == $view['class_id'] ? 'selected' : '') ?>><?php h($class['name']) ?></option>
								<?php endforeach ?>
							</select>
						</dd>
					<dt>名前</dt>
						<dd><input type="text" name="name" size="30" value="<?php t($view['name']) ?>" /></dd>
					<dt>名前（フリガナ）</dt>
						<dd><input type="text" name="name_kana" size="30" value="<?php t($view['name_kana']) ?>" /></dd>
					<dt>成績</dt>
						<dd><input type="text" name="grade" size="5" value="<?php t($view['grade']) ?>" /></dd>
					<dt>誕生日</dt>
						<dd><input type="text" name="birthday" size="30" value="<?php t($view['birthday']) ?>" /></dd>
					<dt>メールアドレス</dt>
						<dd><input type="text" name="email" size="30" value="<?php t($view['email']) ?>" /></dd>
					<dt>メモ</dt>
						<dd><textarea name="memo" rows="10" cols="50"><?php t($view['memo']) ?></textarea></dd>
				</dl>
				<p>
					<input type="button" value="確認する" class="preview" />
					<input type="submit" value="登録する" />
				</p>
			</fieldset>
		</form>

		<?php if (!empty($_GET['id'])) : ?>
		<h2>名簿削除</h2>
		<form action="<?php t(MAIN_FILE) ?>/admin/member_delete" method="post" class="delete">
			<fieldset>
				<legend>削除フォーム</legend>
				<input type="hidden" name="token" value="<?php t($view['token']) ?>" />
				<input type="hidden" name="id" value="<?php t($view['id']) ?>" />
				<p><input type="submit" value="削除する" /></p>
			</fieldset>
		</form>
		<?php endif ?>
	<?php endif ?>

<?php import('app/views/admin/footer.php') ?>
