<?php import('app/views/admin/header.php') ?>

		<h3>名簿一覧</h3>

		<?php if (isset($_GET['ok'])) : ?>
		<ul>
			<?php if ($_GET['ok'] == 'post') : ?>
			<li>データを登録しました。</li>
			<?php elseif ($_GET['ok'] == 'delete') : ?>
			<li>データを削除しました。</li>
			<?php endif ?>
		</ul>
		<?php elseif (isset($_GET['warning'])) : ?>
		<ul>
			<?php if ($_GET['warning'] == 'delete') : ?>
			<li>データが選択されていません。</li>
			<?php endif ?>
		</ul>
		<?php endif ?>

		<form action="<?php t(MAIN_FILE) ?>/admin/member_delete" method="post" id="member_delete">
			<fieldset>
				<legend>削除フォーム</legend>
				<input type="hidden" name="token" value="<?php t($view['token']) ?>" />

				<p><input type="submit" value="削除する" /></p>

				<table>
					<tr>
						<th><input type="checkbox" name="" value="" class="bulks" /> 選択</th>
						<th>ID</th>
						<th>名前</th>
						<th>名前（フリガナ）</th>
						<th>成績</th>
						<th>誕生日</th>
						<th>メールアドレス</th>
						<th>メモ</th>
						<th>教室</th>
						<th>作業</th>
					</tr>
					<?php foreach ($view['members'] as $member) : ?>
					<tr>
						<td><input type="checkbox" name="bulks[]" value="<?php h($member['id']) ?>"<?php echo isset($_SESSION['bulks'][$member['id']]) ? 'checked="checked"' : '' ?> class="bulk" /></td>
						<td><?php h($member['id']) ?></td\>
						<td><?php h($member['name']) ?></td>
						<td><?php h($member['name_kana']) ?></td>
						<td><?php h($member['grade']) ?></td>
						<td><?php h(localdate('Y年m月d日', $member['birthday'])) ?></td>
						<td><?php h($member['email']) ?></td>
						<td><?php h($member['memo']) ?></td>
						<td><?php h($member['class_id']) ?></td>
						<td><a href="<?php t(MAIN_FILE) ?>/admin/member_form?id=<?php t($member['id']) ?>">編集</a></td>
					</tr>
					<?php endforeach ?>
				</table>

			</fieldset>
		</form>

		<h3>ページ移動</h3>
		<ul>
			<li><?php if ($_GET['page'] > 1) : ?><a href="<?php t(MAIN_FILE) ?>/admin/member?page=<?php t($_GET['page'] - 1) ?>">前のページ</a><?php else : ?>前のページ<?php endif ?></li>
			<li><?php if ($view['member_page'] > $_GET['page']) : ?><a href="<?php t(MAIN_FILE) ?>/admin/member?page=<?php t($_GET['page'] + 1) ?>">次のページ</a><?php else : ?>次のページ<?php endif ?></li>
		</ul>
		<ul>
			<?php for ($i = 1; $i <= $view['member_page']; $i++) : ?>
			<li><?php if ($i != $_GET['page']) : ?><a href="<?php t(MAIN_FILE) ?>/admin/member?page=<?php t($i) ?>"><?php t($i) ?></a><?php else : ?><?php t($i) ?><?php endif ?></li>
			<?php endfor ?>
		</ul>

		<?php if (isset($view['member_pager'])) : ?>
			<p><?php echo $view['member_pager'] ?></p>
		<?php endif ?>

<?php import('app/views/admin/footer.php') ?>
