<?php import('app/views/admin/header.php') ?>

	<?php if (isset($_POST['preview']) and $_POST['preview'] == 'yes') : ?>
		<h2>確認</h2>
		<dl>
			<dt>コード</dt>
				<dd><?php h($view['code']) ?></dd>
			<dt>名前</dt>
				<dd><?php h($view['name']) ?></dd>
			<dt>並び順</dt>
				<dd><?php h($view['sort']) ?></dd>
			<dt>メモ</dt>
				<dd><?php h($view['memo']) ?></dd>
			<dt>画像1</dt>
				<dd><img src="<?php t(MAIN_FILE) ?>/admin/class_image?target=image1<?php $view['id'] ? t('&id=' . $view['id']) : '' ?>" /></dd>
			<dt>画像2</dt>
				<dd><img src="<?php t(MAIN_FILE) ?>/admin/class_image?target=image2<?php $view['id'] ? t('&id=' . $view['id']) : '' ?>" /></dd>
		</dl>
		<p><a href="#" class="close">閉じる</a></p>
	<?php else : ?>
		<h2><?php $view['id'] ? h('教室編集') : h('教室登録') ?></h2>

		<?php if (isset($view['warnings'])) : ?>
		<ul>
			<?php foreach ($view['warnings'] as $warning) : ?>
			<li><?php h($warning) ?></li>
			<?php endforeach ?>
		</ul>
		<?php endif ?>

		<form action="<?php t(MAIN_FILE) ?>/admin/class_form<?php $view['id'] ? t('?id=' . $view['id']) : '' ?>" method="post" id="class_post">
			<fieldset>
				<legend>登録フォーム</legend>
				<input type="hidden" name="token" value="<?php t($view['token']) ?>" />
				<input type="hidden" name="id" value="<?php t($view['id']) ?>" />
				<input type="hidden" name="preview" value="no" />
				<dl>
					<dt>コード</dt>
						<dd><input type="text" name="code" size="30" value="<?php t($view['code']) ?>" /></dd>
					<dt>名前</dt>
						<dd><input type="text" name="name" size="30" value="<?php t($view['name']) ?>" /></dd>
					<dt>並び順</dt>
						<dd><input type="text" name="sort" size="5" value="<?php t($view['sort']) ?>" /></dd>
					<dt>メモ</dt>
						<dd><textarea name="memo" rows="10" cols="50"><?php t($view['memo']) ?></textarea></dd>
					<dt>画像1</dt>
						<dd>
							<a href="<?php t(MAIN_FILE) ?>/admin/class_image_upload?target=image1<?php $view['id'] ? t('&id=' . $view['id']) : '' ?>" class="class_image_upload"><img src="<?php t(MAIN_FILE) ?>/admin/class_image?target=image1<?php $view['id'] ? t('&id=' . $view['id']) : '' ?>" id="image1" /></a>
							<div class="class_image_menu" id="image1_menu">
								<ul>
									<li><a href="<?php t(MAIN_FILE) ?>/admin/class_image_process?target=image1<?php $view['id'] ? t('&id=' . $view['id']) : '' ?>" class="class_image_process">加工</a></li>
									<li><a href="<?php t(MAIN_FILE) ?>/admin/class_image_upload?target=image1<?php $view['id'] ? t('&id=' . $view['id']) : '' ?>" class="class_image_upload">差替</a></li>
									<li><a href="<?php t(MAIN_FILE) ?>/admin/class_image_delete?target=image1<?php $view['id'] ? t('&id=' . $view['id']) : '' ?>&token=<?php t($view['token']) ?>" id="image1_delete">削除</a></li>
								</ul>
							</div>
						</dd>
					<dt>画像2</dt>
						<dd>
							<a href="<?php t(MAIN_FILE) ?>/admin/class_image_upload?target=image2<?php $view['id'] ? t('&id=' . $view['id']) : '' ?>" class="class_image_upload"><img src="<?php t(MAIN_FILE) ?>/admin/class_image?target=image2<?php $view['id'] ? t('&id=' . $view['id']) : '' ?>" id="image2" /></a>
							<div class="class_image_menu" id="image2_menu">
								<ul>
									<li><a href="<?php t(MAIN_FILE) ?>/admin/class_image_process?target=image2<?php $view['id'] ? t('&id=' . $view['id']) : '' ?>" class="class_image_process">加工</a></li>
									<li><a href="<?php t(MAIN_FILE) ?>/admin/class_image_upload?target=image2<?php $view['id'] ? t('&id=' . $view['id']) : '' ?>" class="class_image_upload">差替</a></li>
									<li><a href="<?php t(MAIN_FILE) ?>/admin/class_image_delete?target=image2<?php $view['id'] ? t('&id=' . $view['id']) : '' ?>&token=<?php t($view['token']) ?>" id="image2_delete">削除</a></li>
								</ul>
							</div>
						</dd>
				</dl>
				<p>
					<input type="button" value="確認する" class="preview" />
					<input type="submit" value="登録する" />
				</p>
			</fieldset>
		</form>

		<?php if (!empty($_GET['id'])) : ?>
		<h2>教室削除</h2>
		<ul>
			<li>教室を削除すると、その教室に属する名簿も削除されます。</li>
		</ul>
		<form action="<?php t(MAIN_FILE) ?>/admin/class_delete" method="post" class="delete">
			<fieldset>
				<legend>削除フォーム</legend>
				<input type="hidden" name="token" value="<?php t($view['token']) ?>" />
				<input type="hidden" name="id" value="<?php t($view['id']) ?>" />
				<p><input type="submit" value="削除する" /></p>
			</fieldset>
		</form>
		<?php endif ?>
	<?php endif ?>

<?php import('app/views/admin/footer.php') ?>
