<?php

function normalize_members($queries)
{
	//成績
	if (isset($queries['grade'])) {
		$queries['grade'] = mb_convert_kana($queries['grade'], 'n', MAIN_INTERNAL_ENCODING);
	}

	//誕生日
	if (isset($queries['birthday'])) {
		$queries['birthday'] = mb_convert_kana($queries['birthday'], 'n', MAIN_INTERNAL_ENCODING);
	}

	return $queries;
}

function validate_members($queries)
{
	$messages = array();

	//クラス
	if (isset($queries['class_id'])) {
		if ($queries['class_id'] == '') {
			$messages['class_id'] = 'クラスが入力されていません。';
		}
	}

	//名前
	if (isset($queries['name'])) {
		if ($queries['name'] == '') {
			$messages['name'] = '名前が入力されていません。';
		} elseif (mb_strlen($queries['name'], MAIN_INTERNAL_ENCODING) > 20) {
			$messages['name'] = '名前は20文字以内で入力してください。';
		}
	}

	//名前（フリガナ）
	if (isset($queries['name_kana'])) {
		if ($queries['name_kana'] == '') {
			$messages['name_kana'] = '名前（フリガナ）が入力されていません。';
		} elseif (mb_strlen($queries['name_kana'], MAIN_INTERNAL_ENCODING) > 20) {
			$messages['name_kana'] = '名前（フリガナ）は20文字以内で入力してください。';
		} elseif (!preg_match('/^[ァ-ヶー]+$/u', $queries['name_kana'])) {
			$messages['name_kana'] = '名前（フリガナ）は全角カタカナで入力してください。';
		}
	}

	//成績
	if (isset($queries['grade'])) {
		if ($queries['grade'] == '') {
			$messages['grade'] = '成績が入力されていません。';
		} elseif (!preg_match('/^\d+$/', $queries['grade'])) {
			$messages['grade'] = '成績は半角数字で入力してください。';
		} elseif (mb_strlen($queries['grade'], MAIN_INTERNAL_ENCODING) > 3) {
			$messages['grade'] = '成績は3桁以内で入力してください。';
		}
	}

	//誕生日
	if (isset($queries['birthday'])) {
		if (!preg_match('/^\d\d\d\d-\d\d-\d\d$/', $queries['birthday'])) {
			$messages['birthday'] = '誕生日の書式が不正です。';
		}
	}

	//メールアドレス
	if (isset($queries['email'])) {
		if (mb_strlen($queries['email'], MAIN_INTERNAL_ENCODING) > 80) {
			$messages['email'] = 'メールアドレスは80文字以内で入力してください。';
		} elseif (!strpos($queries['email'], '@')) {
			$messages['email'] = 'メールアドレスの入力内容が正しくありません。';
		}
	}

	//メモ
	if (isset($queries['memo'])) {
		if (mb_strlen($queries['memo'], MAIN_INTERNAL_ENCODING) > 1000) {
			$messages['memo'] = 'メモは1000文字以内で入力してください。';
		}
	}

	return $messages;
}

?>
