<?php

function delete_classes($queries)
{
	//削除するデータのIDとファイルを取得
	$classes = select_classes(array(
		'select' => 'id, image1, image2',
		'where'  => isset($queries['where']) ? $queries['where'] : '',
		'limit'  => isset($queries['limit']) ? $queries['limit'] : ''
	));

	$deletes = array();
	$files   = array();
	foreach ($classes as $class) {
		$deletes[] = db_escape($class['id']);
		$files[]   = $class['image1'];
		$files[]   = $class['image2'];
	}

	//トランザクションを開始
	db_transaction();

	//関連する名簿を削除
	$resource = delete_members(array(
		'where' => 'class_id IN(' . implode($deletes) . ')'
	));
	if (!$resource) {
		error('データを削除できません。');
	}

	//データを削除
	$queries['delete_from'] = DATABASE_PREFIX . 'classes';

	$resource = db_delete($queries);

	//関連するファイルを削除
	foreach ($files as $file) {
		if (is_file($GLOBALS['file_targets']['class'] . $file)) {
			unlink($GLOBALS['file_targets']['class'] . $file);
		}
	}

	//トランザクションを終了
	db_commit();

	return $resource;
}

function normalize_classes($queries)
{
	//並び順
	if (isset($queries['sort'])) {
		$queries['sort'] = mb_convert_kana($queries['sort'], 'n', MAIN_INTERNAL_ENCODING);
	}

	return $queries;
}

function validate_classes($queries)
{
	$messages = array();

	//コード
	if (isset($queries['code'])) {
		if ($queries['code'] == '') {
			$messages['code'] = 'コードが入力されていません。';
		} elseif (!preg_match('/^[\w\-]+$/', $queries['code'])) {
			$messages['code'] = 'コードは半角英数字で入力してください。';
		} elseif (mb_strlen($queries['code'], MAIN_INTERNAL_ENCODING) > 20) {
			$messages['code'] = 'コードは20文字以内で入力してください。';
		} else {
			if ($queries['id']) {
				$classes = select_classes(array(
					'select' => 'id',
					'where'  => 'id != ' . db_escape($queries['id']) . ' AND code = ' . db_escape($queries['code'])
				));
			} else {
				$classes = select_classes(array(
					'select' => 'id',
					'where'  => 'code = ' . db_escape($queries['code'])
				));
			}
			if (!empty($classes)) {
				$messages['code'] = '入力されたコードはすでに使用されています。';
			}
		}
	}

	//並び順
	if (isset($queries['sort'])) {
		if ($queries['sort'] == '') {
			$messages['sort'] = '並び順が入力されていません。';
		} elseif (!preg_match('/^\d+$/', $queries['sort'])) {
			$messages['sort'] = '並び順は半角数字で入力してください。';
		} elseif (mb_strlen($queries['sort'], MAIN_INTERNAL_ENCODING) > 5) {
			$messages['sort'] = '並び順は5桁以内で入力してください。';
		}
	}

	//名前
	if (isset($queries['name'])) {
		if ($queries['name'] == '') {
			$messages['name'] = '名前が入力されていません。';
		} elseif (mb_strlen($queries['name'], MAIN_INTERNAL_ENCODING) > 20) {
			$messages['name'] = '名前は20文字以内で入力してください。';
		}
	}

	//メモ
	if (isset($queries['memo'])) {
		if (mb_strlen($queries['memo'], MAIN_INTERNAL_ENCODING) > 1000) {
			$messages['memo'] = 'メモは1000文字以内で入力してください。';
		}
	}

	return $messages;
}

?>
