<?php

import('app/config.php');

if (isset($params[1])) {
	$_GET['code'] = $params[1];
}

if (!isset($_GET['code']) or !preg_match('/^[\w\-]+$/', $_GET['code'])) {
	error('不正なアクセスです。');
}
if (isset($_GET['page'])) {
	$_GET['page'] = intval($_GET['page']);
} else {
	$_GET['page'] = 1;
}

$classes = select_classes(array(
	'select' => 'id',
	'where'  => 'code = ' . db_escape($_GET['code'])
));
if (empty($classes)) {
	warning('教室が見つかりません。');
} else {
	$class = $classes[0];
}

$view['members'] = select_members(array(
	'where'    => 'class_id = ' . db_escape($class['id']),
	'order_by' => 'id',
//	'offset'   => $GLOBALS['limits']['member'] * ($_GET['page'] - 1),
//	'limit'    => $GLOBALS['limits']['member']
	'limit'    => ($GLOBALS['limits']['member'] * ($_GET['page'] - 1)) . ', ' . $GLOBALS['limits']['member']
));

$view['member_count'] = select_members(array(
	'select' => 'COUNT(*) AS count',
	'where'  => 'class_id = ' . db_escape($class['id'])
));
$view['member_count'] = $view['member_count'][0]['count'];
$view['member_page']  = ceil($view['member_count'] / $GLOBALS['limits']['member']);

?>
