<?php

import('app/config.php');

if (empty($_SESSION['login'])) {
	redirect('/admin');
}

if (!token('check')) {
	error('不正なアクセスです。');
}

if (empty($_SESSION['post']['id'])) {
	$resource = insert_members(array(
		'values' => array(
			'class_id'  => db_escape($_SESSION['post']['class_id']),
			'created'   => db_escape(localdate('Y-m-d H:i:s')),
			'modified'  => db_escape(localdate('Y-m-d H:i:s')),
			'name'      => db_escape($_SESSION['post']['name']),
			'name_kana' => db_escape($_SESSION['post']['name_kana']),
			'grade'     => db_escape($_SESSION['post']['grade']),
			'birthday'  => db_escape($_SESSION['post']['birthday']),
			'email'     => db_escape($_SESSION['post']['email']),
			'memo'      => db_escape($_SESSION['post']['memo'])
		)
	));
	if (!$resource) {
		error('データを登録できません。');
	}
} else {
	$resource = update_members(array(
		'sets' => array(
			'class_id'  => db_escape($_SESSION['post']['class_id']),
			'modified'  => db_escape(localdate('Y-m-d H:i:s')),
			'name'      => db_escape($_SESSION['post']['name']),
			'name_kana' => db_escape($_SESSION['post']['name_kana']),
			'grade'     => db_escape($_SESSION['post']['grade']),
			'birthday'  => db_escape($_SESSION['post']['birthday']),
			'email'     => db_escape($_SESSION['post']['email']),
			'memo'      => db_escape($_SESSION['post']['memo'])
		),
		'where' => 'id = ' . db_escape($_SESSION['post']['id'])
	));
	if (!$resource) {
		error('データを編集できません。');
	}
}

unset($_SESSION['post']);

redirect('/admin/member?ok=post');

?>
