<?php

import('app/config.php');

if (empty($_SESSION['login'])) {
	redirect('/admin');
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	if (!token('check')) {
		error('不正なアクセスです。');
	}

	if (isset($_POST['preview']) and $_POST['preview'] == 'yes') {
		$view = $_POST;
	} else {
		$_POST = normalize_members($_POST);

		$warnings = validate_members($_POST);
		if (isset($_POST['type']) && $_POST['type'] == 'json') {
			if (empty($warnings)) {
				ok();
			} else {
				warning($warnings);
			}
		} else {
			if (empty($warnings)) {
				$_SESSION['post'] = $_POST;

				redirect('/admin/member_post?token=' . token('create'));
			} else {
				$view = $_POST;

				$view['warnings'] = $warnings;
			}
		}
	}
} else {
	if (empty($_GET['id'])) {
		$view = array(
			'class_id'  => '',
			'id'        => '',
			'name'      => '',
			'name_kana' => '',
			'grade'     => '',
			'birthday'  => '',
			'email'     => '',
			'memo'      => ''
		);
	} else {
		$members = select_members(array(
			'where' => 'id = ' . db_escape($_GET['id'])
		));
		if (empty($members)) {
			warning('編集データが見つかりません。');
		} else {
			$view = $members[0];
		}
	}

	$view['token'] = token('create');

	unset($_SESSION['post']);
}

$view['classes'] = select_classes(array(
	'order_by' => 'sort, id'
));

?>
