<?php

import('libs/plugins/ui.php');
import('app/config.php');

if (empty($_SESSION['login'])) {
	redirect('/admin');
}

if (isset($_GET['page'])) {
	$_GET['page'] = intval($_GET['page']);
} else {
	$_GET['page'] = 1;

	$_SESSION['bulks'] = array();
}

$view['members'] = select_members(array(
	'order_by' => 'id',
//	'offset'   => $GLOBALS['limits']['member'] * ($_GET['page'] - 1),
//	'limit'    => $GLOBALS['limits']['member']
	'limit'    => ($GLOBALS['limits']['member'] * ($_GET['page'] - 1)) . ', ' . $GLOBALS['limits']['member']
));

$view['member_count'] = select_members(array(
	'select' => 'COUNT(*) AS count'
));
$view['member_count'] = $view['member_count'][0]['count'];
$view['member_page']  = ceil($view['member_count'] / $GLOBALS['limits']['member']);

$view['token'] = token('create');

//ページャー
$pager = ui_pager(array(
	'key'   => 'page',
	'count' => $view['member_count'],
	'size'  => $GLOBALS['limits']['member'],
	'width' => $GLOBALS['pagers']['member'],
	'query' =>'?'
));
if (!empty($pager)) {
	$view['member_pager'] = $pager['first'] . ' ' . $pager['back'] . ' ' . implode(' | ', $pager['pages']) . ' ' . $pager['next'] . ' ' . $pager['last'];
}

?>
