<?php

import('libs/plugins/file.php');
import('app/config.php');

if (empty($_SESSION['login'])) {
	redirect('/admin');
}

$all_warnings = array();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	if (is_uploaded_file($_FILES['file']['tmp_name'])) {
		if ($fp = fopen($_FILES['file']['tmp_name'], 'r')) {
			//トランザクションを開始
			db_transaction();

			//CSVファイル読み込み
			$i = 1;
			while ($line = file_getcsv($fp)) {
				list($class_id, $name, $name_kana, $grade, $birthday, $email, $memo) = $line;

				$post = array(
					'class_id'  => mb_convert_encoding($class_id, 'UTF-8', 'SJIS-WIN'),
					'name'      => mb_convert_encoding($name, 'UTF-8', 'SJIS-WIN'),
					'name_kana' => mb_convert_encoding($name_kana, 'UTF-8', 'SJIS-WIN'),
					'grade'     => mb_convert_encoding($grade, 'UTF-8', 'SJIS-WIN'),
					'birthday'  => mb_convert_encoding($birthday, 'UTF-8', 'SJIS-WIN'),
					'email'     => mb_convert_encoding($email, 'UTF-8', 'SJIS-WIN'),
					'memo'      => mb_convert_encoding($memo, 'UTF-8', 'SJIS-WIN')
				);

				$post = normalize_members($post);

				$warnings = validate_members($post);
				if (empty($warnings)) {
					$resource = insert_members(array(
						'values' => array(
							'class_id'  => db_escape($post['class_id']),
							'created'   => db_escape(localdate('Y-m-d H:i:s')),
							'modified'  => db_escape(localdate('Y-m-d H:i:s')),
							'name'      => db_escape($post['name']),
							'name_kana' => db_escape($post['name_kana']),
							'grade'     => db_escape($post['grade']),
							'birthday'  => db_escape($post['birthday']),
							'email'     => db_escape($post['email']),
							'memo'      => db_escape($post['memo'])
						)
					));
					if (!$resource) {
						db_rollback();

						error('データを登録できません。');
					}
				} else {
					foreach ($warnings as $warning) {
						$all_warnings[] = '[' . $i . '行目] ' . $warning;
					}
				}

				$i++;
			}

			if (empty($all_warnings)) {
				//トランザクションを終了
				db_commit();

				redirect('/admin/csv_upload?ok=post');
			} else {
				$view['warnings'] = $all_warnings;

				//ロールバック
				db_rollback();
			}

			fclose($fp);
		} else {
			$view['warnings'] = array('ファイルを読み込めません。');
		}
	} else {
		$view['warnings'] = array('ファイルを選択してください。');
	}
}

?>
