<?php

import('app/config.php');

if (empty($_SESSION['login'])) {
	redirect('/admin');
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	//CSVダウンロード
	$members = db_select(array(
		'select'   => 'm.*, c.code AS class_code, c.name AS class_name',
		'from'     => DATABASE_PREFIX . 'members AS m LEFT JOIN ' . DATABASE_PREFIX . 'classes AS c ON m.class_id = c.id',
		'order_by' => 'm.id'
	));

	$data  = mb_convert_encoding('"ID","クラスID","登録日時","更新日時","名前","名前（フリガナ）","成績","誕生日","メールアドレス","メモ","クラスコード","クラス名"', 'SJIS-WIN', 'UTF-8');
	$data .= "\n";

	foreach ($members as $member) {
		$flag = false;
		foreach ($member as $value) {
			if ($flag) {
				$data .= ',';
			}

			$data .= '"' . ($value != '' ? str_replace('"', '""', mb_convert_encoding($value, 'SJIS-WIN', 'UTF-8')) : '') . '"';

			$flag = true;
		}
		$data .= "\n";
	}

	header('Content-Type: text/plain');
	header('Content-Disposition: attachment; filename="' . DATABASE_PREFIX . 'members.csv"');
	echo $data;

	exit;
}

?>
