<?php

import('app/config.php');

if (empty($_SESSION['login'])) {
	redirect('/admin');
}

if (!token('check')) {
	error('不正なアクセスです。');
}

if (empty($_SESSION['post']['id'])) {
	$resource = insert_classes(array(
		'values' => array(
			'code'     => db_escape($_SESSION['post']['code']),
			'created'  => db_escape(localdate('Y-m-d H:i:s')),
			'modified' => db_escape(localdate('Y-m-d H:i:s')),
			'sort'     => db_escape($_SESSION['post']['sort']),
			'name'     => db_escape($_SESSION['post']['name']),
			'memo'     => db_escape($_SESSION['post']['memo'])
		)
	));
	if (!$resource) {
		error('データを登録できません。');
	}

	$id = db_last_insert_id();
} else {
	$resource = update_classes(array(
		'sets' => array(
			'code'     => db_escape($_SESSION['post']['code']),
			'modified' => db_escape(localdate('Y-m-d H:i:s')),
			'sort'     => db_escape($_SESSION['post']['sort']),
			'name'     => db_escape($_SESSION['post']['name']),
			'memo'     => db_escape($_SESSION['post']['memo'])
		),
		'where' => 'id = ' . db_escape($_SESSION['post']['id'])
	));
	if (!$resource) {
		error('データを編集できません。');
	}

	$id = $_SESSION['post']['id'];
}

$targets = array('image1', 'image2');
foreach ($targets as $target) {
	if (!empty($_SESSION['file'][$target]['delete']) || !empty($_SESSION['file'][$target]['name'])) {
		$classes = select_classes(array(
			'select' => $target,
			'where'  => 'id = ' . db_escape($id)
		));
		if (empty($classes)) {
			warning('編集データが見つかりません。');
		} else {
			$class = $classes[0];
		}

		if (is_file($GLOBALS['file_targets']['class'] . $class[$target])) {
			unlink($GLOBALS['file_targets']['class'] . $class[$target]);

			$resource = update_classes(array(
				'sets' => array(
					$target => null
				),
				'where' => 'id = ' . db_escape($id)
			));
			if (!$resource) {
				error('データを編集できません。');
			}
		}
	}

	if (empty($_SESSION['file'][$target]['delete']) && !empty($_SESSION['file'][$target]['name'])) {
		if (preg_match('/\.(.*)$/', $_SESSION['file'][$target]['name'], $matches)) {
			$filename = $id . '-' . $target . '.' . $matches[1];

			if (file_put_contents($GLOBALS['file_targets']['class'] . $filename, $_SESSION['file'][$target]['data']) === false) {
				error('ファイル ' . $filename . ' を保存できません。');
			} else {
				$resource = update_classes(array(
					'sets' => array(
						$target => db_escape($filename)
					),
					'where' => 'id = ' . db_escape($id)
				));
				if (!$resource) {
					error('データを編集できません。');
				}
			}
		} else {
			error('ファイル ' . $_SESSION['file'][$target]['name'] . ' の拡張子を取得できません。');
		}
	}
}

unset($_SESSION['post']);
unset($_SESSION['file']);

redirect('/admin/class?ok=post');

?>
