<?php

import('app/config.php');

if (empty($_SESSION['login'])) {
	error('不正なアクセスです。');
}

if (!preg_match('/^(image1|image2)$/', $_GET['target'])) {
	error('不正なアクセスです。');
}

$mime    = null;
$content = null;

if (empty($_SESSION['file'][$_GET['target']]['delete'])) {
	if (isset($_SESSION['file'][$_GET['target']]['name']) && isset($_SESSION['file'][$_GET['target']]['data'])) {
		//ヘッダー
		foreach (array_keys($GLOBALS['file_permissions']['class']) as $permission) {
			if (preg_match($GLOBALS['file_permissions']['class'][$permission]['regexp'], $_SESSION['file'][$_GET['target']]['name'])) {
				$mime = $GLOBALS['file_permissions']['class'][$permission]['mime'];

				break;
			}
		}

		//コンテンツ
		$content = $_SESSION['file'][$_GET['target']]['data'];
	} elseif (isset($_GET['id'])) {
		$classes = select_classes(array(
			'where' => 'id = ' . db_escape($_GET['id'])
		));
		if (empty($classes)) {
			warning('編集データが見つかりません。');
		} else {
			$class = $classes[0];
		}

		$file = $GLOBALS['file_targets']['class'] . $class[$_GET['target']];

		if (is_file($file)) {
			//ヘッダー
			foreach (array_keys($GLOBALS['file_permissions']['class']) as $permission) {
				if (preg_match($GLOBALS['file_permissions']['class'][$permission]['regexp'], $class[$_GET['target']])) {
					$mime = $GLOBALS['file_permissions']['class'][$permission]['mime'];

					break;
				}
			}

			//コンテンツ
			$content = file_get_contents($file);
		}
	}
}

if (isset($_GET['type']) && $_GET['type'] == 'json') {
	if ($content == null) {
		$width  = null;
		$height = null;
	} else {
		list($width, $height) = getimagesize('data:application/octet-stream;base64,' . base64_encode($content));
	}

	header('Content-Type: application/json; charset=' . MAIN_CHARSET);

	echo json_encode(array(
		'status' => 'OK',
		'mime'   => $mime,
		'width'  => $width,
		'height' => $height,
	));
} else {
	if ($mime == null) {
		$mime = 'image/png';
	}
	if ($content == null) {
		$content = file_get_contents('images/noimage.png');
	}

	header('Content-type: ' . $mime);

	echo $content;
}

exit;

?>
