<?php

import('app/config.php');

if (empty($_SESSION['login'])) {
	redirect('/admin');
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	if (!token('check')) {
		error('不正なアクセスです。');
	}

	if (isset($_POST['preview']) and $_POST['preview'] == 'yes') {
		$view = $_POST;
	} else {
		$_POST = normalize_classes($_POST);

		$warnings = validate_classes($_POST);
		if (isset($_POST['type']) && $_POST['type'] == 'json') {
			if (empty($warnings)) {
				ok();
			} else {
				warning($warnings);
			}
		} else {
			if (empty($warnings)) {
				$_SESSION['post'] = $_POST;

				redirect('/admin/class_post?token=' . token('create'));
			} else {
				$view = $_POST;

				$view['warnings'] = $warnings;
			}
		}
	}
} else {
	if (empty($_GET['id'])) {
		$view = array(
			'id'   => '',
			'code' => '',
			'sort' => '',
			'name' => '',
			'memo' => ''
		);
	} else {
		$classes = select_classes(array(
			'where' => 'id = ' . db_escape($_GET['id'])
		));
		if (empty($classes)) {
			warning('編集データが見つかりません。');
		} else {
			$view = $classes[0];
		}
	}

	$view['token'] = token('create');

	unset($_SESSION['post']);
	unset($_SESSION['file']);
}

?>
