<?php

/*********************************************************************

 Functions for UI

*********************************************************************/

function ui_pager($option = array())
{
	if (!isset($option['key'])) {
		$option['key'] = 'page';
	}
	if (!isset($option['now'])) {
		$option['now'] = $_GET[$option['key']];
	}
	if (!isset($option['count'])) {
		$option['count'] = 0;
	}
	if (!isset($option['size'])) {
		$option['size'] = 10;
	}
	if (!isset($option['width'])) {
		$option['width'] = 5;
	}
	if (!isset($option['query'])) {
		$option['query'] = '';
	}
	if (!isset($option['delimiter'])) {
		$option['delimiter'] = ' ';
	}

	if (!isset($option['label']['first'])) {
		$option['label']['first'] = '&lt;&lt;';
	}
	if (!isset($option['label']['last'])) {
		$option['label']['last'] = '&gt;&gt;';
	}
	if (!isset($option['label']['back'])) {
		$option['label']['back'] = '&lt;';
	}
	if (!isset($option['label']['next'])) {
		$option['label']['next'] = '&gt;';
	}

	if ($option['width'] % 2 == 0 || $option['width'] < 5) {
		error('Please specify the five or more odd to \'width\'');
	}

	$option = array(
		'key'       => $option['key'],
		'now'       => intval($option['now']),
		'count'     => intval($option['count']),
		'size'      => intval($option['size']),
		'width'     => intval($option['width']),
		'query'     => $option['query'],
		'delimiter' => $option['delimiter'],
		'label'     => $option['label']
	);

	$pager = array(
		'first' => '',
		'last'  => '',
		'back'  => '',
		'next'  => '',
		'pages' => '',
		'all'   => ''
	);

	$all = ceil($option['count'] / $option['size']);

	if ($all == 1) {
		return array();
	}

	if ($option['now'] > 1) {
		$pager['first'] = '<a href="' . $option['query'] . $option['key'] . '=1">' . $option['label']['first'] . '</a>';
	} else {
		$pager['first'] = $option['label']['first'];
	}

	if ($option['now'] < $all) {
		$pager['last'] = '<a href="' . $option['query'] . $option['key'] . '=' . $all . '">' . $option['label']['last'] . '</a>';
	} else {
		$pager['last'] = $option['label']['last'];
	}

	if ($option['now'] > 1) {
		$pager['back'] = '<a href="' . $option['query'] . $option['key'] . '=' . ($option['now'] - 1) . '">' . $option['label']['back'] . '</a>';
	} else {
		$pager['back'] = $option['label']['back'];
	}

	if ($option['now'] < $all) {
		$pager['next'] = '<a href="' . $option['query'] . $option['key'] . '=' . ($option['now'] + 1) . '">' . $option['label']['next'] . '</a>';
	} else {
		$pager['next'] = $option['label']['next'];
	}

	$pager['pages'] = array();

	$width = $option['width'];
	$side  = intval($option['width'] / 2) + 1;

	if ($all < $option['width']) {
		$from = 1;
		$to   = $all;
	} elseif ($option['now'] <= $side) {
		$from = 1;
		$to   = $from + $side + floor($side / 2);
	} elseif ($option['now'] > $all - $side) {
		$from = $all - $side - floor($side / 2);
		$to   = $all;
	} else {
		$from = $option['now'] - $side + floor($side / 2);
		$to   = $from + $side + floor($side / 2);
	}

	for ($i = $from; $i <= $to; $i++) {
		if ($option['now'] == $i) {
			$pager['pages'][] = $i;
		} else {
			$pager['pages'][] = '<a href="' . $option['query'] . $option['key'] . '=' . $i . '">' . $i . '</a>';
		}
	}

	$pager['all'] = $pager['first'] . $option['delimiter'] . $pager['back'] . $option['delimiter'] . implode($option['delimiter'], $pager['pages']) . $option['delimiter'] . $pager['next'] . $option['delimiter'] . $pager['last'];

	return $pager;
}

?>
