<?php

/*********************************************************************

 Functions for Mail

*********************************************************************/

function mail_send($to, $subject, $message, $headers = array(), $files = array())
{
	$subject = mb_convert_kana(unify($subject), 'KV', MAIN_INTERNAL_ENCODING);
	$message = mb_convert_kana(unify($message), 'KV', MAIN_INTERNAL_ENCODING);

	$subject = mb_convert_encoding($subject, 'JIS', MAIN_INTERNAL_ENCODING);
	$message = mb_convert_encoding($message, 'JIS', MAIN_INTERNAL_ENCODING);

	$subject = '=?iso-2022-jp?B?' . base64_encode($subject) . '?=';

	if (empty($files)) {
		$boundary = null;
	} else {
		$boundary = md5(uniqid(rand(), true));
	}

	if (empty($files)) {
		$body = $message;
	} else {
		$body  = "--$boundary\n";
		$body .= "Content-Type: text/plain; charset=\"iso-2022-jp\"\n";
		$body .= "Content-Transfer-Encoding: 7bit\n";
		$body .= "\n";
		$body .= "$message\n";

		foreach ($files as $file) {
			if (!is_file($file)) {
				continue;
			}

			$filename = basename($file);

			$body .= "\n";
			$body .= "--$boundary\n";
			$body .= "Content-Type: " . freo_mime($file) . "; name=\"$filename\"\n";
			$body .= "Content-Disposition: attachment; filename=\"$filename\"\n";
			$body .= "Content-Transfer-Encoding: base64\n";
			$body .= "\n";
			$body .= chunk_split(base64_encode(file_get_contents($file))) . "\n";
		}

		$body .= '--' . $boundary . '--';
	}

	if (!isset($headers['X-Mailer'])) {
		$headers['X-Mailer'] = 'PHP';
	}
	if (!isset($headers['From'])) {
		$headers['From'] = '"From" <from@example.com>';
	}
	if (!isset($headers['MIME-Version'])) {
		$headers['MIME-Version'] = '1.0';
	}
	if (!isset($headers['Content-Type'])) {
		if (empty($files)) {
			$headers['Content-Type'] = 'text/plain; charset="iso-2022-jp"';
		} else {
			$headers['Content-Type'] = 'multipart/mixed; boundary="' . $boundary . '"';
		}
	}
	if (!isset($headers['Content-Transfer-Encoding'])) {
		$headers['Content-Transfer-Encoding'] = '7bit';
	}

	$header = null;
	foreach ($headers as $key => $value) {
		if ($header) {
			$header .= "\n";
		}

		$header .= $key . ': ' . $value;
	}

	return mail($to, $subject, $body, $header);
}

?>
