<?php

/*********************************************************************

 Functions for DB Driver (pgsql)

*********************************************************************/

function db_driver_connect()
{
	global $db;

	$db = pg_connect('host=' . DATABASE_HOST . (DATABASE_PORT ? ' port=' . DATABASE_PORT : '') . ' dbname=test user=' . DATABASE_USERNAME . ' password=' . DATABASE_PASSWORD);
	if (!$db) {
		error('pg_connect error.' . (DEBUG_LEVEL ? ' [' . DATABASE_HOST . ']' : ''));
	}

	return;
}

function db_driver_query($query)
{
	global $db;

	return pg_query($db, $query);
}

function db_driver_result($resource)
{
	global $db;

	$results = array();
	while ($data = pg_fetch_array($resource, null, PGSQL_ASSOC)) {
		$results[] = $data;
	}

	return $results;
}

function db_driver_count($resource)
{
	global $db;

	return pg_num_rows($resource);
}

function db_driver_affected_count($resource)
{
	global $db;

	return pg_affected_rows($resource);
}

function db_driver_escape($data)
{
	global $db;

	return '\'' . str_replace('\'', '\'\'', $data) . '\'';
}

function db_driver_error()
{
	global $db;

	return pg_result_error($db);
}

function db_driver_transaction()
{
	global $db;

	return pg_query($db, 'START TRANSACTION');
}

function db_driver_commit()
{
	global $db;

	return pg_query($db, 'COMMIT');
}

function db_driver_rollback()
{
	global $db;

	return pg_query($db, 'ROLLBACK');
}

?>
