<?php

/*********************************************************************

 Functions for DB Driver (PDO)

*********************************************************************/

function db_driver_connect()
{
	global $db;

	if (DATABASE_TYPE == 'pdo_mysql') {
		$dsn = 'mysql:dbname=' . DATABASE_NAME . ';host=' . DATABASE_HOST . (DATABASE_PORT ? ';port=' . DATABASE_PORT : '');
	} elseif (DATABASE_TYPE == 'pdo_pgsql') {
		$dsn = 'pgsql:dbname=' . DATABASE_NAME . ';host=' . DATABASE_HOST . (DATABASE_PORT ? ';port=' . DATABASE_PORT : '');
	} elseif (DATABASE_TYPE == 'pdo_sqlite') {
		$dsn = 'sqlite:' . DATABASE_NAME;
	} elseif (DATABASE_TYPE == 'pdo_sqlite2') {
		$dsn = 'sqlite2:' . DATABASE_NAME;
	}

	if (DATABASE_TYPE == 'pdo_mysql') {
		$options = array(
			PDO::ATTR_ERRMODE => PDO::ERRMODE_SILENT,
			PDO::MYSQL_ATTR_USE_BUFFERED_QUERY => true
		);
	} elseif (DATABASE_TYPE == 'pdo_pgsql' or DATABASE_TYPE == 'pdo_sqlite' or DATABASE_TYPE == 'pdo_sqlite2') {
		$options = array(
			PDO::ATTR_ERRMODE => PDO::ERRMODE_SILENT
		);
	}

	try {
		$db = new PDO($dsn, DATABASE_USERNAME, DATABASE_PASSWORD, $options);
	} catch (PDOException $e) {
		error('pdo_connect error.' . (DEBUG_LEVEL ? ' [' . $e->getMessage() . ']' : ''));
	}

	return;
}

function db_driver_query($query)
{
	global $db;

	return $db->query($query);
}

function db_driver_result($resource)
{
	global $db;

	$results = array();
	while ($data = $resource->fetch(PDO::FETCH_ASSOC)) {
		$results[] = $data;
	}

	return $results;
}

function db_driver_count($resource)
{
	global $db;

	return $resource->rowCount();
}

function db_driver_affected_count($resource)
{
	global $db;

	return $resource->rowCount();
}

function db_driver_escape($data)
{
	global $db;

	if (DATABASE_TYPE == 'pdo_mysql') {
		return '\'' . addslashes($data) . '\'';
	} elseif (DATABASE_TYPE == 'pdo_pgsql' or DATABASE_TYPE == 'pdo_sqlite' or DATABASE_TYPE == 'pdo_sqlite2') {
		return '\'' . str_replace('\'', '\'\'', $data) . '\'';
	}
}

function db_driver_error()
{
	global $db;

	$info = $db->errorInfo();
	if (isset($info[2]) and $info[2] != 'not an error') {
		$error = $info[2];
	}

	return $error;
}

function db_driver_last_insert_id($resource)
{
	global $db;

	return $db->lastInsertId();
}

function db_driver_transaction()
{
	global $db;

	return $db->beginTransaction();
}

function db_driver_commit()
{
	global $db;

	return $db->commit();
}

function db_driver_rollback()
{
	global $db;

	return $db->rollBack();
}

?>
