<?php

/*********************************************************************

 DB Admin Ver 2.01 (2012/07/27)

*********************************************************************/

/********* ライセンス ************************************************

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 @Link http://www.php-labo.net/
 @Copyright(C) 2007-2012 PHP Labo
 @Author Knight <info at php-labo dot net>

*********************************************************************/

/********* 設定項目 *************************************************/

//プログラム格納ディレクトリのURL
define('HTTP_URL', 'http://www.example.com/db_admin/');

//管理者パスワード
define('ADMIN_PASSWORD', '1234');

//データベースの種類(sqlite3 ... SQLite3 / sqlite2 ... SQLite2 / mysql ... MySQL)
define('DATABASE_TYPE', 'sqlite3');

//接続先(MySQL用)
define('DATABASE_HOST', '');

//ポート(MySQL用)
define('DATABASE_PORT', '');

//ユーザー名(MySQL用)
define('DATABASE_USER', '');

//パスワード(MySQL用)
define('DATABASE_PASSWORD', '');

//文字コード(MySQL用)
define('DATABASE_CHARSET', '');

//データベース名(コンマ区切りで複数指定可能)
define('DATABASE_NAME', 'database/database.db');

//セッションCookieの有効期限
define('SESSION_LIFETIME', 0);

//セッションのキャッシュ制御
define('SESSION_CACHE', 'none');

//プログラム実行時間の最大値
define('TIME_LIMIT', 0);

//プログラムの文字コード
define('SCRIPT_CHARSET', 'utf-8');

//プログラムファイル名
define('MAIN_FILE', 'index.php');

//CSSファイル名
define('CSS_FILE', 'common.css');

/********* メイン処理 ***********************************************/

//セッション開始
session();

//データ正規化
normalize();

//ログイン状態チェック
if (isloggedin()) {
	//データベース選択
	db_select();

	//データベース接続
	$pdo = db_connect();

	//モードに応じた処理を実行
	if (!isset($_REQUEST['mode'])) {
		$_REQUEST['mode'] = null;
	}
	if ($_REQUEST['mode'] == 'form') {
		admin_form();
	} elseif ($_REQUEST['mode'] == 'insert') {
		admin_insert();
	} elseif ($_REQUEST['mode'] == 'update') {
		admin_update();
	} elseif ($_REQUEST['mode'] == 'delete') {
		admin_delete();
	} elseif ($_REQUEST['mode'] == 'export') {
		admin_export();
	} elseif ($_REQUEST['mode'] == 'import') {
		admin_import();
	} elseif ($_REQUEST['mode'] == 'phpinfo') {
		admin_phpinfo();
	} elseif ($_REQUEST['mode'] == 'logout') {
		admin_logout();
	} else {
		admin_db();
	}
} else {
	admin();
}

exit;

/********* ユーザー定義関数 *****************************************/

/* ログイン状態チェック */
function isloggedin()
{
	global $pdo;

	if (isset($_POST['password'])) {
		//パスワード認証
		if ($_POST['password'] == ADMIN_PASSWORD) {
			$_SESSION['login'] = true;
		}

		header('Location: ' . HTTP_URL . MAIN_FILE . '?mode=default');

		exit;
	}

	if (isset($_SESSION['login']) and $_SESSION['login'] == true) {
		return true;
	} else {
		return false;
	}
}

/* 認証ページ */
function admin()
{
	global $pdo;

	//エラーメッセージ取得
	if (isset($_REQUEST['mode']) and $_REQUEST['mode'] == 'default') {
		$message = 'パスワードが違います。';
	} else {
		$message = 'パスワードを入力してください。';
	}

	//データ表示
	$js  = "window.onload = function()\n";
	$js .= "{\n";
	$js .= "\tdocument.getElementById('login_form').password.focus();\n";
	$js .= "}";

	print_header(CSS_FILE, $js);

	echo "<div id=\"admin\">\n";
	echo "<h2>パスワード認証</h2>\n";
	echo "<ul>\n";
	echo "<li>$message</li>\n";
	echo "</ul>\n";
	echo "<form action=\"" . HTTP_URL . MAIN_FILE . "\" method=\"post\" id=\"login_form\">\n";
	echo "<fieldset>\n";
	echo "<legend>認証フォーム</legend>\n";
	echo "<dl>\n";
	echo "<dt>パスワード</dt>\n";
	echo "<dd><input type=\"password\" name=\"password\" size=\"20\" value=\"\" /></dd>\n";
	echo "</dl>\n";
	echo "<p><input type=\"submit\" value=\"認証する\" /></p>\n";
	echo "</fieldset>\n";
	echo "</form>\n";
	echo "</div>\n";

	print_footer();

	return;
}

/* SQL実行 */
function admin_db($sql = '')
{
	global $pdo;

	if (isset($_POST['sql']) and $_POST['sql'] != '') {
		$sql = $_POST['sql'];
	}

	if ($sql) {
		//アクセス元チェック
		if (isset($_SERVER['HTTP_REFERER']) and !preg_match('/^' . preg_quote(HTTP_URL, '/') . '/', $_SERVER['HTTP_REFERER'])) {
			error('不正なアクセスです。');
		}

		//ワンタイムトークン比較
		if (!preg_match('/^(SELECT|SHOW|EXPLAIN|DESC|PRAGMA)/i', $sql) and !token_check()) {
			error('不正なアクセスです。');
		}

		//ワンタイムトークン破棄
		token_destroy();

		//処理開始時間取得
		$start = get_microtime();

		//SQL実行
		$html    = '';
		$message = '<code>' . htmlspecialchars($sql, ENT_QUOTES) . '</code> が実行されました。';

		if (preg_match('/^SHOW TABLES;?$/i', $sql) or preg_match('/^SELECT name FROM sqlite_master WHERE type=\'table\';?$/i', $sql)) {
			//テーブル一覧
			$stmt = $pdo->query($sql);
			if (!$stmt) {
				error('<code>' . htmlspecialchars($sql, ENT_QUOTES) . '</code> を実行できませんでした。');
			}

			$rows   = 0;
			$fields = $stmt->columnCount();

			$html .= "<table summary=\"テーブル一覧\">";
			$html .= "<tr>";
			$html .= "<th>テーブル名</th>";
			$html .= "<th>作成コード</th>";
			$html .= "<th>定義内容</th>";
			$html .= "<th>テーブル削除</th>";
			$html .= "<th>データ登録</th>";
			$html .= "<th>データ表示</th>";
			$html .= "</tr>";

			while ($data = $stmt->fetch(PDO::FETCH_NUM)) {
				$table = nl2br(htmlspecialchars($data[0], ENT_QUOTES));

				if (DATABASE_TYPE == 'mysql') {
					$create     = "SHOW CREATE TABLE";
					$create_sql = "SHOW CREATE TABLE $table;";
					$define     = "SHOW COLUMNS";
					$define_sql = "SHOW COLUMNS FROM $table;";
				} else {
					$create     = "SELECT sql";
					$create_sql = "SELECT sql FROM sqlite_master WHERE tbl_name = \\'$table\\';";
					$define     = "PRAGMA TABLE_INFO";
					$define_sql = "PRAGMA TABLE_INFO(\\'$table\\');";
				}

				$html .= "<tr>";
				$html .= "<td>$table</td>";
				$html .= "<td><a href=\"javascript:execSQL('$create_sql');\">$create</a></td>";
				$html .= "<td><a href=\"javascript:execSQL('$define_sql');\">$define</a></td>";
				$html .= "<td><a href=\"javascript:execSQL('DROP TABLE $table;', '本当に削除してもよろしいですか？');\">DROP TABLE</a></td>";
				$html .= "<td><a href=\"" . HTTP_URL . MAIN_FILE . "?mode=form&amp;work=insert&amp;table=$table\">INSERT</a></td>";
				$html .= "<td><a href=\"javascript:execSQL('SELECT * FROM $table LIMIT 100;');\">SELECT</a></td>";
				$html .= "</tr>";

				$rows++;
			}

			$html .= "</table>";
		} elseif (preg_match('/^(SELECT|SHOW|EXPLAIN|DESC|PRAGMA)/i', $sql)) {
			//データ取得
			if (preg_match('/^SELECT \* FROM (\S+)([^;]*)/i', $sql, $matches)) {
				$flag      = true;
				$table     = $matches[1];
				$condition = $matches[2];
			} else {
				$flag      = false;
				$table     = '';
				$condition = '';
			}

			if (DATABASE_TYPE == 'mysql') {
				$stmt = $pdo->query($sql);
				if (!$stmt) {
					error('<code>' . htmlspecialchars($sql, ENT_QUOTES) . '</code> を実行できませんでした。');
				}

				$rows   = 0;
				$fields = $stmt->columnCount();

				$html .= "<table summary=\"結果一覧\">";
				$html .= "<tr>";

				$primary_keys = array();
				$keys         = array();

				for ($i = 0; $i < $fields; $i++) {
					$info = $stmt->getColumnMeta($i);

					if ($flag) {
						if (in_array('primary_key', $info['flags'])) {
							$primary_keys[$i] = $info['name'];
						} else {
							$keys[$i] = $info['name'];
						}
					}

					$html .= "<th>" . nl2br(htmlspecialchars($info['name'], ENT_QUOTES)) . "</th>";
				}

				if ($flag) {
					$html .= "<th>編集・削除</th>";
				}

				$html .= "</tr>";

				while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
					$html .= "<tr>";

					$i    = 0;
					$form = '';

					foreach ($row as $data) {
						if ($flag) {
							if (empty($primary_keys)) {
								if ($data === null) {
									$form .= "<input type=\"hidden\" name=\"nulls[" . $keys[$i] . "]\" value=\"1\" />";
								} else {
									$form .= "<input type=\"hidden\" name=\"keys[" . $keys[$i] . "]\" value=\"" . htmlspecialchars($data, ENT_QUOTES) . "\" />";
								}
							} elseif (isset($primary_keys[$i])) {
								$form .= "<input type=\"hidden\" name=\"primary_keys[" . $primary_keys[$i] . "]\" value=\"" . htmlspecialchars($data, ENT_QUOTES) . "\" />";
							}
						}

						if ($data === null) {
							$html .= "<td><em>NULL</em></td>";
						} else {
							$html .= "<td>" . nl2br(htmlspecialchars($data, ENT_QUOTES)) . "</td>";
						}

						$i++;
					}

					if ($flag) {
						$html .= "<td>";
						$html .= "<form action=\"" . HTTP_URL . MAIN_FILE . "\" method=\"post\">\n";
						$html .= "<fieldset>\n";
						$html .= "<legend>編集・削除フォーム</legend>\n";
						$html .= "<input type=\"hidden\" name=\"mode\" value=\"form\" />\n";
						$html .= "<input type=\"hidden\" name=\"work\" value=\"update\" />\n";
						$html .= "<input type=\"hidden\" name=\"table\" value=\"$table\" />$form\n";
						$html .= "<p><input type=\"submit\" value=\"編集・削除\" /></p>\n";
						$html .= "</fieldset>\n";
						$html .= "</form>\n";
						$html .= "</td>";
					}

					$html .= "</tr>";

					$rows++;
				}

				$html .= "</table>";
			} else {
				if ($flag) {
					$stmt = $pdo->query('SELECT *, rowid FROM ' . $table . $condition);
				} else {
					$stmt = $pdo->query($sql);
				}
				if (!$stmt) {
					error('<code>' . htmlspecialchars($sql, ENT_QUOTES) . '</code> を実行できませんでした。');
				}

				$rows   = 0;
				$fields = $stmt->columnCount();

				$html .= "<table summary=\"結果一覧\">";
				$html .= "<tr>";

				for ($i = 0; $i < $fields; $i++) {
					$info = $stmt->getColumnMeta($i);

					if ($info['name']) {
						if ($flag and $info['name'] == 'rowid') {
							$html .= "<th>編集・削除</th>";
						} else {
							$html .= "<th>" . nl2br(htmlspecialchars($info['name'], ENT_QUOTES)) . "</th>";
						}
					}
				}

				$html .= "</tr>";

				while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
					$html .= "<tr>";

					$j = 1;

					foreach ($row as $data) {
						if ($flag and $j == $i) {
							$rowid = $data;
						} elseif ($data === null) {
							$html .= "<td><em>NULL</em></td>";
						} else {
							$html .= "<td>" . nl2br(htmlspecialchars($data, ENT_QUOTES)) . "</td>";
						}

						$j++;
					}

					if ($flag) {
						$html .= "<td>";
						$html .= "<form action=\"" . HTTP_URL . MAIN_FILE . "\" method=\"post\">\n";
						$html .= "<fieldset>\n";
						$html .= "<legend>編集・削除フォーム</legend>\n";
						$html .= "<input type=\"hidden\" name=\"mode\" value=\"form\" />\n";
						$html .= "<input type=\"hidden\" name=\"work\" value=\"update\" />\n";
						$html .= "<input type=\"hidden\" name=\"table\" value=\"$table\" />\n";
						$html .= "<input type=\"hidden\" name=\"rowid\" value=\"$rowid\" />\n";
						$html .= "<p><input type=\"submit\" value=\"編集・削除\" /></p>\n";
						$html .= "</fieldset>\n";
						$html .= "</form>\n";
						$html .= "</td>";
					}

					$html .= "</tr>";

					$rows++;
				}

				$html .= "</table>";
			}
		} else {
			//処理実行
			$stmt = $pdo->query($sql);
			if (!$stmt) {
				error('<code>' . htmlspecialchars($sql, ENT_QUOTES) . '</code> を実行できませんでした。');
			}

			$rows = $stmt->rowCount();
		}

		//処理終了時間取得
		$end = get_microtime();

		//処理時間取得
		$time = ceil(($end - $start) * 10000) / 10000;
	} else {
		$html    = '';
		$message = '実行したいSQLを入力してください。';
		$rows    = 0;
		$fields  = 0;
		$time    = 0;
	}

	//ワンタイムトークン作成
	$token = token_create();

	//データ表示
	$js  = "function execSQL(sql, text)\n";
	$js .= "{\n";
	$js .= "\tif (!text || window.confirm(text)) {\n";
	$js .= "\t\tdocument.getElementById('exec_form').sql.value = sql;\n";
	$js .= "\t\tdocument.getElementById('exec_form').submit();\n";
	$js .= "\t}\n";
	$js .= "}";

	print_header(CSS_FILE, $js);

	if (DATABASE_TYPE == 'mysql') {
		echo "<div id=\"menu\">\n";
		echo "<h2>メニュー</h2>\n";
		echo "<ul>\n";
		echo "<li><a href=\"javascript:execSQL('SHOW TABLES;');\">テーブル一覧</a></li>\n";
		echo "<li><a href=\"" . HTTP_URL . MAIN_FILE . "?mode=export\">エクスポート</a></li>\n";
		echo "<li><a href=\"" . HTTP_URL . MAIN_FILE . "?mode=import\">インポート</a></li>\n";
		echo "<li><a href=\"" . HTTP_URL . MAIN_FILE . "?mode=phpinfo\">phpinfo()</a></li>\n";
		echo "<li><a href=\"" . HTTP_URL . MAIN_FILE . "?mode=logout\">ログアウト</a></li>\n";
		echo "</ul>\n";
		echo "</div>\n";
	} else {
		echo "<div id=\"menu\">\n";
		echo "<h2>メニュー</h2>\n";
		echo "<ul>\n";
		echo "<li><a href=\"javascript:execSQL('SELECT name FROM sqlite_master WHERE type=\\'table\\';');\">テーブル一覧</a></li>\n";
		echo "<li><a href=\"javascript:execSQL('VACUUM;', '本当に実行してもよろしいですか？');\">データ最適化</a></li>\n";
		echo "<li><a href=\"" . HTTP_URL . MAIN_FILE . "?mode=export\">エクスポート</a></li>\n";
		echo "<li><a href=\"" . HTTP_URL . MAIN_FILE . "?mode=import\">インポート</a></li>\n";
		echo "<li><a href=\"" . HTTP_URL . MAIN_FILE . "?mode=phpinfo\">phpinfo()</a></li>\n";
		echo "<li><a href=\"" . HTTP_URL . MAIN_FILE . "?mode=logout\">ログアウト</a></li>\n";
		echo "</ul>\n";
		echo "</div>\n";
	}
	echo "<div id=\"exec\">\n";
	echo "<h2>SQL実行</h2>\n";
	echo "<ul>\n";
	echo "<li>$message</li>\n";
	echo "<li>作業対象データベースは <code>" . $_SESSION['database'] . "</code> です。</li>\n";
	echo "</ul>\n";
	echo "<form action=\"" . HTTP_URL . MAIN_FILE . "\" method=\"post\" id=\"exec_form\">\n";
	echo "<fieldset>\n";
	echo "<legend>実行フォーム</legend>\n";
	echo "<input type=\"hidden\" name=\"token\" value=\"$token\" />\n";
	echo "<dl>\n";
	echo "<dt>SQL</dt>\n";
	echo "<dd><textarea name=\"sql\" cols=\"50\" rows=\"5\">" . htmlspecialchars($sql, ENT_QUOTES) . "</textarea></dd>\n";
	echo "</dl>\n";
	echo "<p><input type=\"submit\" value=\"実行する\" /></p>\n";
	echo "</fieldset>\n";
	echo "</form>\n";
	echo "</div>\n";
	if ($time or $html) {
		echo "<div id=\"result\">\n";
	}
	if ($time) {
		echo "<h2>実行結果</h2>\n";
		echo "<dl>\n";
		echo "<dt>rows</dt><dd>$rows rows</dd>\n";
		echo "<dt>time</dt><dd>$time sec</dd>\n";
		echo "</dl>\n";
	}
	if ($html) {
		echo "$html\n";
	}
	if ($time or $html) {
		echo "</div>\n";
	}
	if (strpos(DATABASE_NAME, ',')) {
		$databases = explode(',', DATABASE_NAME);

		echo "<div id=\"database\">\n";
		echo "<h2>データベース</h2>\n";
		echo "<form action=\"" . HTTP_URL . MAIN_FILE . "\" method=\"post\" id=\"select_form\">\n";
		echo "<fieldset>\n";
		echo "<legend>データベース選択フォーム</legend>\n";
		echo "<dl>\n";
		echo "<dt>データベース</dt>\n";
		echo "<dd>\n";
		echo "<select name=\"database\" onchange=\"this.form.submit();\">\n";
		echo "<option value=\"\">選択してください</option>\n";
		foreach ($databases as $database) {
			echo "<option value=\"$database\">$database</option>\n";
		}
		echo "</select>\n";
		echo "</dd>\n";
		echo "</dl>\n";
		echo "<noscript>\n";
		echo "<p><input type=\"submit\" value=\"選択する\" /></p>\n";
		echo "</noscript>\n";
		echo "</fieldset>\n";
		echo "</form>\n";
		echo "</div>\n";
	}

	print_footer();

	return;
}

/* 登録フォーム表示 */
function admin_form()
{
	global $pdo;

	$form = '';

	//オリジナルデータ取得
	if ($_REQUEST['work'] == 'update') {
		if (DATABASE_TYPE == 'mysql') {
			$conditions = array();
			if (isset($_POST['primary_keys'])) {
				foreach ($_POST['primary_keys'] as $key => $value) {
					$conditions[] = $key . ' = ' . $pdo->quote($value);
					$form .= "<input type=\"hidden\" name=\"primary_keys[$key]\" value=\"" . htmlspecialchars($value, ENT_QUOTES) . "\" />";
				}
			} else {
				foreach ($_POST['keys'] as $key => $value) {
					$conditions[] = $key . ' = ' . $pdo->quote($value);
					$form .= "<input type=\"hidden\" name=\"keys[$key]\" value=\"" . htmlspecialchars($value, ENT_QUOTES) . "\" />";
				}
				if (isset($_POST['nulls'])) {
					foreach ($_POST['nulls'] as $key => $value) {
						$conditions[] = $key . ' IS NULL';
						$form .= "<input type=\"hidden\" name=\"nulls[$key]\" value=\"1\" />";
					}
				}
			}
			$condition = implode(' AND ', $conditions);

			$sql = 'SELECT * FROM ' . $_POST['table'] . ' WHERE ' . $condition . ' LIMIT 1';
		} else {
			$condition = 'rowid = ' . $pdo->quote($_POST['rowid']);
			$form      = "<input type=\"hidden\" name=\"rowid\" value=\"" . htmlspecialchars($_POST['rowid'], ENT_QUOTES) . "\" />";

			$sql = 'SELECT * FROM ' . $_POST['table'] . ' WHERE ' . $condition . ' LIMIT 1';
		}

		$stmt = $pdo->query($sql);
		if (!$stmt) {
			error('<code>' . htmlspecialchars($sql, ENT_QUOTES) . '</code> を実行できませんでした。');
		}

		if (!($originals = $stmt->fetch(PDO::FETCH_ASSOC))) {
			error('データを取得できません。');
		}

		foreach ($originals as $key => $value) {
			if ($value !== null) {
				$form .= "<input type=\"hidden\" name=\"original[$key]\" value=\"" . htmlspecialchars($value, ENT_QUOTES) . "\" />";
			}
		}
	}

	//テーブル定義取得
	if (DATABASE_TYPE == 'mysql') {
		$sql = 'SHOW COLUMNS FROM ' . $_REQUEST['table'];
	} else {
		$sql = 'PRAGMA TABLE_INFO(\'' . $_REQUEST['table'] . '\')';
	}

	$stmt = $pdo->query($sql);
	if (!$stmt) {
		error('<code>' . htmlspecialchars($sql, ENT_QUOTES) . '</code> を実行できませんでした。');
	}

	//ワンタイムトークン作成
	$token = token_create();

	//データ表示
	print_header(CSS_FILE);

	echo "<div id=\"menu\">\n";
	echo "<h2>メニュー</h2>\n";
	echo "<ul>\n";
	echo "<li><a href=\"" . HTTP_URL . MAIN_FILE . "\">戻る</a></li>\n";
	echo "</ul>\n";
	echo "</div>\n";
	if ($_REQUEST['work'] == 'update') {
		echo "<div id=\"update\">\n";
		echo "<h2>データ編集</h2>\n";
	} else {
		echo "<div id=\"insert\">\n";
		echo "<h2>データ登録</h2>\n";
	}
	echo "<ul>\n";
	echo "<li>登録したいデータを入力してください。</li>\n";
	echo "</ul>\n";
	echo "<form action=\"" . HTTP_URL . MAIN_FILE . "\" method=\"post\">\n";
	echo "<fieldset>\n";
	echo "<legend>登録フォーム</legend>\n";
	echo "<input type=\"hidden\" name=\"mode\" value=\"" . $_REQUEST['work'] . "\" />$form\n";
	echo "<input type=\"hidden\" name=\"table\" value=\"" . $_REQUEST['table'] . "\" />\n";
	echo "<input type=\"hidden\" name=\"token\" value=\"$token\" />\n";
	echo "<table summary=\"データ一覧\">";
	echo "<tr>";
	echo "<th>フィールド</th>";
	echo "<th>型</th>";
	echo "<th>ヌル</th>";
	echo "<th>キー</th>";
	echo "<th>値</th>";
	if (DATABASE_TYPE == 'mysql') {
		echo "<th>その他</th>";
	}
	echo "</tr>";

	if (DATABASE_TYPE == 'mysql') {
		while ($data = $stmt->fetch(PDO::FETCH_ASSOC)) {
			if ($_REQUEST['work'] == 'insert') {
				$original = $data['Default'];
			} else {
				$original = $originals[$data['Field']];
			}

			echo "<tr>";
			echo "<td>" . $data['Field'] . "</td>";
			echo "<td>" . $data['Type'] . "</td>";

			if ($_REQUEST['work'] == 'insert' and $data['Key'] == 'PRI') {
				echo "<td><input type=\"checkbox\" name=\"null[" . $data['Field'] . "]\" value=\"1\" checked=\"checked\" /></td>";
			} elseif ($data['Null'] == 'YES') {
				echo "<td><input type=\"checkbox\" name=\"null[" . $data['Field'] . "]\" value=\"1\"" . ($original === null ? " checked=\"checked\"" : "") . " /></td>";
			} else {
				echo "<td></td>";
			}

			echo "<td>" . $data['Key'] . "</td>";

			if (preg_match('/^(tinyblob|blob|mediumblob|longblob|tinytext|text|mediumtext|longtext)/i', $data['Type'])) {
				echo "<td><textarea name=\"data[" . $data['Field'] . "]\" cols=\"50\" rows=\"5\">" . htmlspecialchars($original, ENT_QUOTES) . "</textarea></td>";
			} elseif (preg_match('/^(varchar|char)/i', $data['Type'])) {
				echo "<td><input type=\"text\" name=\"data[" . $data['Field'] . "]\" size=\"50\" value=\"" . htmlspecialchars($original, ENT_QUOTES) . "\" /></td>";
			} else {
				echo "<td><input type=\"text\" name=\"data[" . $data['Field'] . "]\" size=\"20\" value=\"" . htmlspecialchars($original, ENT_QUOTES) . "\" /></td>";
			}

			echo "<td>" . $data['Extra'] . "</td>";
			echo "</tr>";
		}
	} else {
		while ($data = $stmt->fetch(PDO::FETCH_ASSOC)) {
			if ($_REQUEST['work'] == 'insert') {
				$original = $data['dflt_value'];
			} else {
				$original = $originals[$data['name']];
			}

			echo "<tr>";
			echo "<td>" . $data['name'] . "</td>";
			echo "<td>" . $data['type'] . "</td>";

			if ($_REQUEST['work'] == 'insert' and $data['pk'] == 1) {
				echo "<td><input type=\"checkbox\" name=\"null[" . $data['name'] . "]\" value=\"1\" checked=\"checked\" /></td>";
			} elseif ($data['notnull'] == 0) {
				echo "<td><input type=\"checkbox\" name=\"null[" . $data['name'] . "]\" value=\"1\"" . ($original === null ? " checked=\"checked\"" : "") . " /></td>";
			} else {
				echo "<td></td>";
			}

			echo "<td>" . $data['pk'] . "</td>";

			if (preg_match('/^(tinyblob|blob|mediumblob|longblob|tinytext|text|mediumtext|longtext)/i', $data['type'])) {
				echo "<td><textarea name=\"data[" . $data['name'] . "]\" cols=\"50\" rows=\"5\">" . htmlspecialchars($original, ENT_QUOTES) . "</textarea></td>";
			} elseif (preg_match('/^(varchar|char)/i', $data['type'])) {
				echo "<td><input type=\"text\" name=\"data[" . $data['name'] . "]\" size=\"50\" value=\"" . htmlspecialchars($original, ENT_QUOTES) . "\" /></td>";
			} else {
				echo "<td><input type=\"text\" name=\"data[" . $data['name'] . "]\" size=\"20\" value=\"" . htmlspecialchars($original, ENT_QUOTES) . "\" /></td>";
			}

			echo "</tr>";
		}
	}

	echo "</table>";
	echo "</fieldset>\n";
	if ($_REQUEST['work'] == 'update') {
		echo "<p><input type=\"submit\" value=\"編集する\" /></p>\n";
	} else {
		echo "<p><input type=\"submit\" value=\"登録する\" /></p>\n";
	}
	echo "</form>\n";
	echo "</div>\n";

	if ($_REQUEST['work'] == 'update') {
		echo "<div id=\"delete\">\n";
		echo "<h2>データ削除</h2>\n";
		echo "<ul>\n";
		echo "<li>このデータを削除します。</li>\n";
		echo "</ul>\n";
		echo "<form action=\"" . HTTP_URL . MAIN_FILE . "\" method=\"post\" onsubmit=\"return window.confirm('本当に削除してもよろしいですか？');\">\n";
		echo "<fieldset>\n";
		echo "<legend>削除フォーム</legend>\n";
		echo "<input type=\"hidden\" name=\"mode\" value=\"delete\" />$form\n";
		echo "<input type=\"hidden\" name=\"table\" value=\"" . $_REQUEST['table'] . "\" />\n";
		echo "<input type=\"hidden\" name=\"token\" value=\"$token\" />\n";
		echo "</fieldset>\n";
		echo "<p><input type=\"submit\" value=\"削除する\" /></p>\n";
		echo "</form>\n";
		echo "</div>\n";
	}

	print_footer();

	return;
}

/* 登録実行 */
function admin_insert()
{
	global $pdo;

	//テーブル定義取得
	if (DATABASE_TYPE == 'mysql') {
		$sql = 'SHOW COLUMNS FROM ' . $_POST['table'];
	} else {
		$sql = 'PRAGMA TABLE_INFO(\'' . $_POST['table'] . '\')';
	}

	$stmt = $pdo->query($sql);
	if (!$stmt) {
		error('<code>' . htmlspecialchars($sql, ENT_QUOTES) . '</code> を実行できませんでした。');
	}

	//登録内容取得
	$inserts = array();
	while ($data = $stmt->fetch(PDO::FETCH_ASSOC)) {
		if (DATABASE_TYPE == 'mysql') {
			$field = $data['Field'];
		} else {
			$field = $data['name'];
		}
		if (empty($_POST['null'][$field])) {
			$inserts[$field] = $pdo->quote($_POST['data'][$field]);
		} else {
			$inserts[$field] = 'NULL';
		}
	}
	$insert_key   = array_keys($inserts);
	$insert_value = array_values($inserts);

	//SQL実行
	admin_db('INSERT INTO ' . $_POST['table'] . '(' . implode(', ', $insert_key) . ') VALUES(' . implode(', ', $insert_value) . ')');

	return;
}

/* 編集実行 */
function admin_update()
{
	global $pdo;

	//条件取得
	if (DATABASE_TYPE == 'mysql') {
		$conditions = array();
		if (isset($_POST['primary_keys'])) {
			foreach ($_POST['primary_keys'] as $key => $value) {
				$conditions[] = $key . ' = ' . $pdo->quote($value);
			}
		} else {
			foreach ($_POST['keys'] as $key => $value) {
				$conditions[] = $key . ' = ' . $pdo->quote($value);
			}
			if (isset($_POST['nulls'])) {
				foreach ($_POST['nulls'] as $key => $value) {
					$conditions[] = $key . ' IS NULL';
				}
			}
		}
		$condition = implode(' AND ', $conditions);
	} else {
		$condition = 'rowid = ' . $pdo->quote($_POST['rowid']);
	}

	//テーブル定義取得
	if (DATABASE_TYPE == 'mysql') {
		$sql = 'SHOW COLUMNS FROM ' . $_POST['table'];
	} else {
		$sql = 'PRAGMA TABLE_INFO(\'' . $_POST['table'] . '\')';
	}

	$stmt = $pdo->query($sql);
	if (!$stmt) {
		error('<code>' . htmlspecialchars($sql, ENT_QUOTES) . '</code> を実行できませんでした。');
	}

	//編集内容取得
	$updates = array();
	while ($data = $stmt->fetch(PDO::FETCH_ASSOC)) {
		if (DATABASE_TYPE == 'mysql') {
			$field = $data['Field'];
		} else {
			$field = $data['name'];
		}
		if (empty($_POST['null'][$field])) {
			$value = $_POST['data'][$field];
		} else {
			$value = null;
		}
		if (isset($_POST['original'][$field])) {
			$original = $_POST['original'][$field];
		} else {
			$original = null;
		}

		if ($value !== $original) {
			if ($value === null) {
				$updates[] = $field . ' = NULL';
			} else {
				$updates[] = $field . ' = ' . $pdo->quote($value);
			}
		}
	}
	$update = implode(', ', $updates);

	if (!$update) {
		error('データが変更されていません。');
	}

	//更新数制限
	if (DATABASE_TYPE == 'mysql') {
		$limit = ' LIMIT 1';
	} else {
		$limit = '';
	}

	//SQL実行
	admin_db('UPDATE ' . $_POST['table'] . ' SET ' . $update . ' WHERE ' . $condition . $limit);

	return;
}

/* 削除実行 */
function admin_delete()
{
	global $pdo;

	//条件取得
	if (DATABASE_TYPE == 'mysql') {
		$conditions = array();
		if (isset($_POST['primary_keys'])) {
			foreach ($_POST['primary_keys'] as $key => $value) {
				$conditions[] = $key . ' = ' . $pdo->quote($value);
			}
		} else {
			foreach ($_POST['keys'] as $key => $value) {
				$conditions[] = $key . ' = ' . $pdo->quote($value);
			}
			if (isset($_POST['nulls'])) {
				foreach ($_POST['nulls'] as $key => $value) {
					$conditions[] = $key . ' IS NULL';
				}
			}
		}
		$condition = implode(' AND ', $conditions);
	} else {
		$condition = 'rowid = ' . $pdo->quote($_POST['rowid']);
	}

	//削除数制限
	if (DATABASE_TYPE == 'mysql') {
		$limit = ' LIMIT 1';
	} else {
		$limit = '';
	}

	//SQL実行
	admin_db('DELETE FROM ' . $_POST['table'] . ' WHERE ' . $condition . $limit);

	return;
}

/* エクスポート */
function admin_export()
{
	global $pdo;

	//テーブル一覧取得
	$tables = array();
	if (DATABASE_TYPE == 'mysql') {
		$sql = 'SHOW TABLES;';
	} else {
		$sql = 'SELECT name FROM sqlite_master WHERE type = \'table\';';
	}

	$stmt = $pdo->query($sql);
	if (!$stmt) {
		error('<code>' . htmlspecialchars($sql, ENT_QUOTES) . '</code> を実行できませんでした。');
	}

	while ($data = $stmt->fetch(PDO::FETCH_NUM)) {
		$tables[] = $data[0];
	}

	//出力実行
	if (isset($_POST['mode']) and $_POST['mode'] == 'export') {
		//アクセス元チェック
		if (isset($_SERVER['HTTP_REFERER']) and !preg_match('/^' . preg_quote(HTTP_URL, '/') . '/', $_SERVER['HTTP_REFERER'])) {
			error('不正なアクセスです。');
		}

		//データ出力
		if (TIME_LIMIT) {
			set_time_limit(TIME_LIMIT);
		}

		$text  = '-- Database: ' . $_SESSION['database'] . ' (' . (DATABASE_TYPE == 'mysql' ? 'MySQL' : 'SQLite') . ")\n";
		$text .= '-- Datetime: ' . date('Y-m-d H:i:s') . "\n";
		$text .= '-- Host: ' . gethostbyaddr($_SERVER['REMOTE_ADDR']) . "\n";
		$text .= "\n";

		foreach ($tables as $table) {
			if (empty($_POST['target']) or $_POST['target'] == $table) {
				//テーブル定義
				if (DATABASE_TYPE == 'mysql') {
					$sql  = 'SHOW CREATE TABLE ' . $table . ';';
					$stmt = $pdo->query($sql);
					if (!$stmt) {
						error('<code>' . htmlspecialchars($sql, ENT_QUOTES) . '</code> を実行できませんでした。');
					}

					if ($data = $stmt->fetch(PDO::FETCH_NUM)) {
						$text .= "DROP TABLE IF EXISTS $table;\n";
						$text .= $data[1] . ";\n";
						$text .= "\n";
					}
				} else {
					$sql  = 'SELECT sql FROM sqlite_master WHERE tbl_name = \'' . $table . '\';';
					$stmt = $pdo->query($sql);
					if (!$stmt) {
						error('<code>' . htmlspecialchars($sql, ENT_QUOTES) . '</code> を実行できませんでした。');
					}

					if ($data = $stmt->fetch(PDO::FETCH_NUM)) {
						$text .= "DROP TABLE IF EXISTS $table;\n";
						$text .= $data[0] . ";\n";
						$text .= "\n";
					}
				}

				//テーブルデータ
				$sql  = 'SELECT * FROM ' . $table . ';';
				$stmt = $pdo->query($sql);
				if (!$stmt) {
					error('<code>' . htmlspecialchars($sql, ENT_QUOTES) . '</code> を実行できませんでした。');
				}

				while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
					$datas = array();
					foreach ($row as $data) {
						if ($data === null) {
							$datas[] = 'NULL';
						} else {
							$datas[] = $pdo->quote($data);
						}
					}
					$text .= "INSERT INTO $table VALUES(" . implode(',', $datas) . ");\n";
				}
				$text .= "\n";
			}
		}

		//出力
		header('Content-Type: text/plain');
		header('Content-Disposition: attachment; filename="' . $_SESSION['database'] . '.sql"');
		echo $text;
		exit;
	}

	//データ表示
	print_header(CSS_FILE);

	echo "<div id=\"menu\">\n";
	echo "<h2>メニュー</h2>\n";
	echo "<ul>\n";
	echo "<li><a href=\"" . HTTP_URL . MAIN_FILE . "\">戻る</a></li>\n";
	echo "</ul>\n";
	echo "</div>\n";
	echo "<div id=\"export\">\n";
	echo "<h2>エクスポート</h2>\n";
	echo "<ul>\n";
	echo "<li>ファイルにデータを出力します。</li>\n";
	echo "<li>作業対象データベースは <code>" . $_SESSION['database'] . "</code> です。</li>\n";
	echo "</ul>\n";
	echo "<form action=\"" . HTTP_URL . MAIN_FILE . "\" method=\"post\">\n";
	echo "<fieldset>\n";
	echo "<legend>出力フォーム</legend>\n";
	echo "<input type=\"hidden\" name=\"mode\" value=\"export\" />\n";
	echo "<dl>\n";
	echo "<dt>対象</dt>\n";
	echo "<dd>\n";
	echo "<select name=\"target\">\n";
	echo "<option value=\"\">すべて</option>\n";
	if (!empty($tables)) {
		foreach ($tables as $table) {
			echo "<option value=\"$table\">$table</option>\n";
		}
	}
	echo "</select>\n";
	echo "</dd>\n";
	echo "</dl>\n";
	echo "<p><input type=\"submit\" value=\"出力する\" /></p>\n";
	echo "</fieldset>\n";
	echo "</form>\n";
	echo "</div>\n";

	print_footer();

	return;
}

/* インポート */
function admin_import()
{
	global $pdo;

	//出力実行
	if (isset($_POST['mode']) and $_POST['mode'] == 'import') {
		//アクセス元チェック
		if (isset($_SERVER['HTTP_REFERER']) and !preg_match('/^' . preg_quote(HTTP_URL, '/') . '/', $_SERVER['HTTP_REFERER'])) {
			error('不正なアクセスです。');
		}

		//ワンタイムトークン比較
		if (!token_check()) {
			error('不正なアクセスです。');
		}

		//データ入力
		if (TIME_LIMIT) {
			set_time_limit(TIME_LIMIT);
		}

		if (is_uploaded_file($_FILES['target']['tmp_name'])) {
			if ($fp = fopen($_FILES['target']['tmp_name'], 'r')) {
				$sql      = '';
				$i        = 0;
				$complete = true;

				while ($line = fgets($fp)) {
					$line = str_replace("\r\n", "\n", $line);
					$line = str_replace("\r", "\n", $line);

					if ((substr_count($line, '\'') - substr_count($line, '\\\'')) % 2 != 0) {
						$complete = !$complete;
					}

					$sql .= $line;

					if (preg_match('/;$/', trim($line)) and $complete) {
						$stmt = $pdo->query($sql);
						if (!$stmt) {
							error('<code>' . htmlspecialchars($sql, ENT_QUOTES) . '</code> を実行できませんでした。');
						}

						$sql = '';
						$i++;
					}
				}
				fclose($fp);

				$message = '<code>' . $i . '</code> のSQLが実行されました。';
			} else {
				error('ファイルを読み込めません。');
			}
		} else {
			error('ファイルを選択してください。');
		}

		//ワンタイムトークン破棄
		token_destroy();
	} else {
		$message = 'ファイルからデータを入力します。';
	}

	//ワンタイムトークン作成
	$token = token_create();

	//データ表示
	print_header(CSS_FILE);

	echo "<div id=\"menu\">\n";
	echo "<h2>メニュー</h2>\n";
	echo "<ul>\n";
	echo "<li><a href=\"" . HTTP_URL . MAIN_FILE . "\">戻る</a></li>\n";
	echo "</ul>\n";
	echo "</div>\n";
	echo "<div id=\"import\">\n";
	echo "<h2>インポート</h2>\n";
	echo "<ul>\n";
	echo "<li>$message</li>\n";
	echo "<li>作業対象データベースは <code>" . $_SESSION['database'] . "</code> です。</li>\n";
	echo "</ul>\n";
	echo "<form action=\"" . HTTP_URL . MAIN_FILE . "\" method=\"post\" enctype=\"multipart/form-data\">\n";
	echo "<fieldset>\n";
	echo "<legend>入力フォーム</legend>\n";
	echo "<input type=\"hidden\" name=\"mode\" value=\"import\" />\n";
	echo "<input type=\"hidden\" name=\"token\" value=\"$token\" />\n";
	echo "<dl>\n";
	echo "<dt>対象</dt>\n";
	echo "<dd><input type=\"file\" name=\"target\" size=\"30\" /></dd>\n";
	echo "</dl>\n";
	echo "<p><input type=\"submit\" value=\"入力する\" /></p>\n";
	echo "</fieldset>\n";
	echo "</form>\n";
	echo "</div>\n";

	print_footer();

	return;
}

/* PHP設定確認 */
function admin_phpinfo()
{
	global $pdo;

	//設定表示
	phpinfo();

	return;
}

/* ログアウト */
function admin_logout()
{
	global $pdo;

	//セッション情報クリア
	$_SESSION['database'] = null;
	$_SESSION['login']    = false;

	//認証ページ
	admin();

	return;
}

/* エラー表示 */
function error($message)
{
	global $pdo;

	$info = $pdo->errorInfo();

	print_header(CSS_FILE);

	echo "<p>$message</p>\n";
	if (isset($info[2]) and $info[2] != 'not an error') {
		echo "<p>$info[2]</p>\n";
	}

	print_footer();

	exit;
}

/* ヘッダー出力 */
function print_header($css = '', $js = '')
{
	echo "<?xml version=\"1.0\" encoding=\"" . SCRIPT_CHARSET . "\"?>\n";
	echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n";
	echo "<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"ja\" lang=\"ja\" dir=\"ltr\">\n";
	echo "<head>\n";
	echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" . SCRIPT_CHARSET . "\" />\n";
	if ($css) {
		echo "<meta http-equiv=\"Content-Style-Type\" content=\"text/css\" />\n";
	}
	if ($js) {
		echo "<meta http-equiv=\"Content-Script-Type\" content=\"text/javascript\" />\n";
	}
	echo "<title>DB Admin</title>\n";
	if ($css) {
		echo "<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\" media=\"all\" />\n";
	}
	if ($js) {
		echo "<script type=\"text/javascript\">\n";
		echo "//<![CDATA[\n";
		echo "$js\n";
		echo "//]]>\n";
		echo "</script>\n";
	}
	echo "</head>\n";
	echo "<body>\n";
	echo "<h1>DB Admin</h1>\n";

	return;
}

/* フッター出力 */
function print_footer()
{
	echo "<address><a href=\"http://www.php-labo.net/\">DB Admin</a></address>\n";
	echo "</body>\n";
	echo "</html>\n";

	return;
}

/* セッション開始 */
function session()
{
	$info = parse_url(HTTP_URL);

	session_set_cookie_params(SESSION_LIFETIME, $info['path']);
	session_cache_limiter(SESSION_CACHE);
	session_start();
	session_regenerate_id(true);

	return;
}

/* データ正規化 */
function normalize()
{
	$_GET     = sanitize($_GET);
	$_POST    = sanitize($_POST);
	$_REQUEST = sanitize($_REQUEST);
	$_SERVER  = sanitize($_SERVER);
	$_COOKIE  = sanitize($_COOKIE);

	$_GET     = unify($_GET);
	$_POST    = unify($_POST);
	$_REQUEST = unify($_REQUEST);
	$_SERVER  = unify($_SERVER);
	$_COOKIE  = unify($_COOKIE);

	return;
}

/* データベース選択 */
function db_select()
{
	if (isset($_POST['database'])) {
		$_SESSION['database'] = $_POST['database'];
	} elseif (empty($_SESSION['database'])) {
		$databases = explode(',', DATABASE_NAME);

		$_SESSION['database'] = $databases[0];
	}

	return;
}

/* データベース接続 */
function db_connect()
{
	if (DATABASE_TYPE == 'sqlite3') {
		$dsn = 'sqlite:' . $_SESSION['database'];
	} elseif (DATABASE_TYPE == 'sqlite2') {
		$dsn = 'sqlite2:' . $_SESSION['database'];
	} else {
		$dsn = 'mysql:dbname=' . $_SESSION['database'] . ';host=' . DATABASE_HOST . (DATABASE_PORT ? ';port=' . DATABASE_PORT : '');
	}

	if (DATABASE_TYPE == 'mysql') {
		$options = array(
			PDO::ATTR_ERRMODE => PDO::ERRMODE_SILENT,
			PDO::MYSQL_ATTR_USE_BUFFERED_QUERY => true
		);
	} else {
		$options = array(
			PDO::ATTR_ERRMODE => PDO::ERRMODE_SILENT
		);
	}

	try {
		$pdo = new PDO($dsn, DATABASE_USER, DATABASE_PASSWORD, $options);
	} catch (PDOException $e) {
		exit($e->getMessage());
	}

	if (DATABASE_TYPE == 'mysql' and DATABASE_CHARSET) {
		$sql  = 'SET NAMES ' . DATABASE_CHARSET;
		$stmt = $pdo->query($sql);
		if (!$stmt) {
			error('<code>' . htmlspecialchars($sql, ENT_QUOTES) . '</code> を実行できませんでした。');
		}
	}

	return $pdo;
}

/* ワンタイムトークン作成 */
function token_create()
{
	global $users;

	$token = session_id();

	$_SESSION['token'] = $token;

	return $token;
}

/* ワンタイムトークン比較 */
function token_check()
{
	global $users;

	if (isset($_REQUEST['token']) and isset($_SESSION['token']) and $_REQUEST['token'] == $_SESSION['token']) {
		return true;
	} else {
		return false;
	}
}

/* ワンタイムトークン破棄 */
function token_destroy()
{
	global $users;

	$_SESSION['token'] = '';

	return;
}

/* マイクロタイム取得 */
function get_microtime()
{
	list($micro, $second) = explode(' ', microtime());

	$microtime = $micro + $second;

	return $microtime;
}

/* 不正データ削除 */
function sanitize($data)
{
	if (is_array($data)) {
		return array_map('sanitize', $data);
	}

	return str_replace("\0", '', $data);
}

/* 改行コード統一 */
function unify($data)
{
	if (is_array($data)) {
		return array_map('unify', $data);
	}

	$data = preg_replace("/\r?\n/", "\r", $data);
	$data = preg_replace("/\r/", "\n", $data);

	return $data;
}

?>
